<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_admin_administrators_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.adminEdit')) ?>


<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/admin.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>


<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.administration'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.Administrators'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_edit', array('id' => $administrator->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.AdminEdit'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-users-outline"></i><?php echo $view['translator']->trans('admin.listTitle'); ?> - <?php echo $view['translator']->trans('adminEdit.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
<?php echo $view['translator']->trans('adminEdit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
            <div class="box">
                <div class="box-header bg-transparent">
                    <!-- tools box -->
                    <h3 class="box-title"><i class="icon-user-outline"></i>
                        <span><?php echo $view['translator']->trans('adminEdit.listSubTitle'); ?>
                            - <?php echo(!empty($administrator->getfirstName()) ? $administrator->getfirstName() . ' ' . $administrator->getlastName() : $administrator->getlogin()); ?></span>
                    </h3></div>
                <!-- /.box-header -->
                <div class="box-body " style="display: block;">
                    <div class="row">
                        <div class="large-2 columns">
                            <p><strong><?php echo $view['translator']->trans('adminAdd.dataAdmin'); ?></strong></p>
                            <p><?php echo $view['translator']->trans('adminAdd.dataAdminSub'); ?></p>
                            <p><?php echo $view['translator']->trans('adminEdit.dataAdminSub'); ?></p>
                        </div>
                        <div class="large-10 columns">
                            <div class="wi-konatkt-form">
                                <?php if ($view['form']->errors($addEditForm)): ?>
                                    <div class="alert callout small">
                                        <?php echo $view['form']->errors($addEditForm); ?>
                                    </div>
                                <?php endif; ?>
                                <?php echo $view['form']->start($addEditForm) ?>
                                <?php echo $view['form']->errors($addEditForm) ?>
                                <div class="row">
                                    <div class="medium-6 columns">
                                        <?php echo $view['form']->label($addEditForm['login']) ?>
                                        <?php echo '<div class="formAlert">'.$view['form']->errors($addEditForm['login']).'</div>' ?>
                                        <?php echo ($view['form']->errors($addEditForm['login']) ? $view['form']->widget($addEditForm['login'], array('attr' => array('class' =>'callout alert', 'value' => $administrator->getlogin()))) : $view['form']->widget($addEditForm['login'], array('attr' => array('value' => $administrator->getlogin())))) ?>
                                    </div>
                                    <div class="medium-6 columns">
                                        <?php echo $view['form']->label($addEditForm['email']) ?>
                                        <?php echo '<div class="formAlert">'.$view['form']->errors($addEditForm['email']).'</div>' ?>
                                        <?php //echo $view['form']->widget($addEditForm['email'], array('attr' => array('value' => $administrator->getemail()))) ?>
                                        <?php echo ($view['form']->errors($addEditForm['email']) ? $view['form']->widget($addEditForm['email'], array('attr' => array('class' =>'callout alert', 'value' => $administrator->getemail()))) : $view['form']->widget($addEditForm['email'], array('attr' => array('value' => $administrator->getemail())))) ?>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="medium-6 columns">
                                        <?php echo $view['form']->label($addEditForm['password']['first']) ?>
                                        <?php echo '<div class="formAlert">'.$view['form']->errors($addEditForm['password']['first']).'</div>' ?>
                                        <?php echo ($view['form']->errors($addEditForm['password']['first']) ? $view['form']->widget($addEditForm['password']['first'], array('required' => false, 'attr' => array('class' =>'callout alert', 'novalidate' => 'novalidate'))) : $view['form']->widget($addEditForm['password']['first'], ['required' => false, 'attr' => ['novalidate' => 'novalidate']])) ?>
                                    </div>
                                    <div class="medium-6 columns">
                                        <?php echo $view['form']->label($addEditForm['password']['second']) ?>
                                        <?php echo '<div class="formAlert">'.$view['form']->errors($addEditForm['password']['second']).'</div>' ?>
                                        <?php echo ($view['form']->errors($addEditForm['password']['first']) ? $view['form']->widget($addEditForm['password']['second'], array('required' => false, 'attr' => array('class' =>'callout alert', 'novalidate' => 'novalidate'))) : $view['form']->widget($addEditForm['password']['second'], array('required' => false, 'attr' => array('novalidate' => 'novalidate')))) ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="large-2 columns">
                            <p><strong><?php echo $view['translator']->trans('adminAdd.personalData'); ?></strong></p>
                            <p><?php echo $view['translator']->trans('adminAdd.personalDataDesc'); ?></p>
                        </div>
                        <div class="large-10 columns">
                            <div class="wi-konatkt-form">
                                <div class="row">
                                    <div class="medium-6 columns">
                                        <?php echo $view['form']->label($addEditForm['firstName']) ?>
                                        <?php echo '<div class="formAlert">'.$view['form']->errors($addEditForm['firstName']).'</div>' ?>
                                        <?php echo ($view['form']->errors($addEditForm['firstName']) ? $view['form']->widget($addEditForm['firstName'], array('attr' => array('class' =>'callout alert', 'value' => $administrator->getfirstName()))) : $view['form']->widget($addEditForm['firstName'], array('attr' => array('value' => $administrator->getfirstName())))) ?>
                                    </div>
                                    <div class="medium-6 columns">
                                        <?php echo $view['form']->label($addEditForm['lastName']) ?>
                                        <?php echo '<div class="formAlert">'.$view['form']->errors($addEditForm['lastName']).'</div>' ?>
                                        <?php echo ($view['form']->errors($addEditForm['lastName']) ? $view['form']->widget($addEditForm['lastName'], array('attr' => array('class' =>'callout alert', 'value' => $administrator->getlastName()))) : $view['form']->widget($addEditForm['lastName'], array('attr' => array('value' => $administrator->getlastName())))) ?>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="medium-6 columns end">
                                        <?php echo $view['form']->label($addEditForm['displayName']) ?>
                                        <div class="formAlert">
                                            <?php echo $view['form']->errors($addEditForm['displayName']) ?>
                                        </div>
                                        <?php echo ($view['form']->errors($addEditForm['displayName']) ? $view['form']->widget($addEditForm['displayName'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($addEditForm['displayName'])) ?>
                                    </div>
                                    <div class="medium-6 columns end">
                                        <?php echo $view['form']->label($addEditForm['job']) ?>
                                        <?php echo '<div class="formAlert">'.$view['form']->errors($addEditForm['job']).'</div>' ?>
                                        <?php echo ($view['form']->errors($addEditForm['job']) ? $view['form']->widget($addEditForm['job'], array('attr' => array('class' =>'callout alert', 'value' => $administrator->getjob()))) : $view['form']->widget($addEditForm['job'], array('attr' => array('value' => $administrator->getjob())))) ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="large-2 columns">
                        </div>
                        <div class="large-10 columns">
                            <div class="wi-konatkt-form">
                                <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>"><i class="icon-edit"></i> <?php echo $view['translator']->trans('Form.send'); ?></button>
                                <?php echo $view['form']->end($addEditForm) ?>
                                <a class="button secondary float-right" href="<?php echo $app->getRequest()->server->get('HTTP_REFERER') ? $app->getRequest()->server->get('HTTP_REFERER') : $view['router']->path('wi_admin_admin_administrators_show', array('id' => $administrator->getId())); ?>">
                                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                    <?php if ($view['security']->isGranted('ROLE_ADMINISTRATORS_EDIT_PERMISSIONS')): ?>
                        <hr>
                        <div class="row">
                            <div class="large-2 columns">
                                <p><strong><?php echo $view['translator']->trans('adminShow.role'); ?></strong></p>
                                <p><?php echo $view['translator']->trans('adminShow.roleDesc'); ?></p>
                            </div>
                            <div class="large-10 columns">
                                <ul>
                                    <?php foreach ($administrator->getRoles() as $role): ?>
                                        <li>
                                            <?php echo $view['translator']->trans($role); ?>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                                <?php if ($view['security']->isGranted('ROLE_ADMINISTRATORS_EDIT_PERMISSIONS')): ?>
                                    <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_edit_permission', array('id' => $administrator->getId())); ?>" class="button tiny">
                                        <span><i class="icon-edit"></i><?php echo $view['translator']->trans('adminShow.editPerButton'); ?></span>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <!-- end .timeline -->
            </div>
            <!-- box -->
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/admin.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
