<?php

namespace Wi\Admin\AdminBundle\Service;

use Wi\Admin\AdminBundle\Entity\Administrator;
use Wi\Admin\CoreBundle\Service\Mailer as BaseMailer;

/**
 * Mailer.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class Mailer extends BaseMailer
{
    /**
     * Wysłanie maila z linkiem do zresetowania hasła.
     *
     * @param Administrator $administrator
     * @return int
     */
    public function sendForgotPasswordEmail(Administrator $administrator)
    {
        $this->message
            ->setTo($administrator->getEmail())
            ->setSubject('Resetuj hasło')
            ->setBody(
                $this->render('WiAdminAdminBundle:templates:emails/forgot_password.html.php', [
                    'administrator' => $administrator,
                ]),
                'text/html'
            )
        ;

        return $this->send();
    }
}
