<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_advertising_block_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('ads.meta.title', [], 'ads')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/commercial.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li><a href="<?php echo $view['router']->path('wi_admin_advertising_block_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.ads', [], 'ads'); ?></a></li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_advertising_block_new'); ?>">
            <?php echo $view['translator']->trans('breadcrumbs.new', [], 'ads'); ?>
        </a>
    </li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-megaphone"></i><?php echo $view['translator']->trans('ads.title_new', [], 'ads'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-megaphone"></i>
                <span><?php echo $view['translator']->trans('ads.title_new', [], 'ads'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('ads.form.name.title', [], 'ads'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('ads.form.name.desc', [], 'ads'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['name']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['name']) ? $view['form']->widget($form['name'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['name'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('ads.form.description.title', [], 'ads'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('ads.form.description.desc', [], 'ads'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['description']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['description']) ? $view['form']->widget($form['description'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['description'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('ads.form.type.title', [], 'ads'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('ads.form.type.desc', [], 'ads'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['type']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['type']) ? $view['form']->widget($form['type'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['type'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('ads.form.time.title', [], 'ads'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('ads.form.time.desc', [], 'ads'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['time']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['time']) ? $view['form']->widget($form['time'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['time'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('ads.form.randomDisplay.title', [], 'ads'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('ads.form.randomDisplay.desc', [], 'ads'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['randomDisplay']); ?>
                            </div>
                            <div class="">
                                <?php echo $view['form']->errors($form['randomDisplay']); ?>
                                <?php echo $view['form']->widget($form['randomDisplay']); ?>
                                <label class="switch-paddle" for="<?php echo $form->children['randomDisplay']->vars['id']; ?>">
                                    <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                    <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <div class="news-add-form">
                        <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                            <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
                        </button>

                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_advertising_block_index'); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/commercial.js') ?>"></script>
<?php $view['slots']->stop(); ?>
