<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_advertising_block_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('ads.meta.title', [], 'ads')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css') ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/lib/codemirror.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/link-generator/css/link-generator.css') ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/commercial.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li><a href="<?php echo $view['router']->path('wi_admin_advertising_block_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.ads', [], 'ads'); ?></a></li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_advertisement_new', ['id' => $advertisingBlock->getId()]); ?>">
            <?php echo $view['translator']->trans('breadcrumbs.newItem', [], 'ads'); ?>
        </a>
    </li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-megaphone"></i><?php echo $view['translator']->trans('ads.advertisement.add', [], 'ads'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-megaphone"></i>
                <span><?php echo $view['translator']->trans('ads.advertisement.add', [], 'ads'); ?></span>
            </h3>
        </div><!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row <?php echo ! in_array($advertisingBlock->getType(), [$advertisingBlock::TYPE_HTML]) ? 'hide' : null; ?>">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('ads.advertisement.form.html.title', [], 'ads'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('ads.advertisement.form.html.desc', [], 'ads'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['html']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['html']) ? $view['form']->widget($form['html'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['html'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr class="<?php echo ! in_array($advertisingBlock->getType(), [$advertisingBlock::TYPE_HTML]) ? 'hide' : null; ?>">
            <div class="row <?php echo ! in_array($advertisingBlock->getType(), [$advertisingBlock::TYPE_BANNER, $advertisingBlock::TYPE_SLIDER]) ? 'hide' : null; ?>">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('ads.advertisement.form.image.title', [], 'ads'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('ads.advertisement.form.image.desc', [], 'ads'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['file']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['file']) ? $view['form']->widget($form['file'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['file'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr class="<?php echo ! in_array($advertisingBlock->getType(), [$advertisingBlock::TYPE_BANNER, $advertisingBlock::TYPE_SLIDER]) ? 'hide' : null; ?>">
            <div class="row <?php echo ! in_array($advertisingBlock->getType(), [$advertisingBlock::TYPE_BANNER, $advertisingBlock::TYPE_SLIDER]) ? 'hide' : null; ?>">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('ads.advertisement.form.link.title', [], 'ads'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('ads.advertisement.form.link.desc', [], 'ads'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['link']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['link']) ? $view['form']->widget($form['link'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['link'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr class="<?php echo ! in_array($advertisingBlock->getType(), [$advertisingBlock::TYPE_BANNER, $advertisingBlock::TYPE_SLIDER]) ? 'hide' : null; ?>">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('ads.advertisement.form.dateStart.title', [], 'ads'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('ads.advertisement.form.dateStart.desc', [], 'ads'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['dateStart']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['dateStart']) ? $view['form']->widget($form['dateStart'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['dateStart'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('ads.advertisement.form.dateEnd.title', [], 'ads'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('ads.advertisement.form.dateEnd.desc', [], 'ads'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['dateEnd']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['dateEnd']) ? $view['form']->widget($form['dateEnd'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['dateEnd'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('ads.advertisement.form.status.title', [], 'ads'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('ads.advertisement.form.status.desc', [], 'ads'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['status']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['status']) ? $view['form']->widget($form['status'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['status'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <div class="news-add-form">
                        <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                            <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
                        </button>

                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_advertising_block_index'); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php echo $view['form']->widget($form); ?>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/lib/codemirror.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/xml/xml.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/javascript/javascript.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/css/css.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/vbscript/vbscript.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/htmlmixed/htmlmixed.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/commercial.js') ?>"></script>
<?php $view['slots']->stop(); ?>
