<?php

namespace Wi\Admin\BannerBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\BannerBundle\Entity\BannerSet;

/**
 * Załadowanie grup stron do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadBannerSetData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $bannerSet = $this->getBannerSet($data);
            $this->addReference('nb-bannerSet-'.$data['id'], $bannerSet);

            // Przygotowanie do zapisu.
            $manager->persist($bannerSet);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($bannerSet));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 11;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            [
                'id' => 1,
                'name' => 'Strona Główna',
                'status' => 'A',
            ],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\NewsBundle\Entity\Category
     */
    private function getBannerSet(array $data)
    {
        return (new BannerSet())
            ->setId($data['id'])
            ->setName($data['name'])
            ->setStatus($data['status'])
        ;
    }
}
