<?php

namespace Wi\Admin\BannerBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\BannerBundle\Entity\BannerSet;


/**
 * BannerSet Listener.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BannerSetListener
{
    /**
     * Metoda wykonywana jest przed usunięciem obiektu.
     *
     * @param   BannerSet           $bannerSet
     * @param   LifecycleEventArgs  $event
     */
    public function preRemove(BannerSet $bannerSet, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $bannerSet->setStatus('D');

        foreach($bannerSet->getBanners() as $banner) {
            $banner->setStatus('D');
            $em->persist($banner);
            $em->flush();
        }

        // Zapis.
        $em->persist($bannerSet);
        $em->flush();
    }
}
