<?php

namespace Wi\Admin\BannerBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\BannerBundle\Entity\Banner;

/**
 * Banner Creator.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BannerType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('imageURL')
            ->add('content', TextareaType::class, [
                'attr' => [
                    'maxlength' => 65535,
                    'rows' => 10,
                    'class' => 'tinyMCE',
                ],
                'label' => 'content',
                'required' => false,
            ])
            ->add('linkURL', TextType::class, [
                'attr' => [
                    'maxlength' => 256,
                    'placeholder' => 'blockNew.form.nameTitle',
                    'class' => 'link-generator'
                ],
                'label' => 'linkURL',
                'required' => false,
            ])
            ->add('altTitle', TextType::class, [
                'attr' => [
                    'maxlength' => 256,
                    'placeholder' => 'blockNew.form.nameTitle',
                ],
                'label' => 'altTitle',
                'required' => false,
            ])
            ->add('dateStart', DateTimeType::class, [
                'attr' => [
                    'class' => 'dateStart',
                    'placeholder' => 'blockNew.form.dateStart',
                ],
                'format' => 'dd-MM-yyyy',
                'widget' => 'single_text',
                'required' => false,
                'label' => 'dateStart',
            ])
            ->add('dateEnd', DateTimeType::class, [
                'attr' => [
                    'class' => 'dateEnd',
                    'placeholder' => 'blockNew.form.dateEnd',
                ],
                'format' => 'dd-MM-yyyy',
                'widget' => 'single_text',
                'required' => false,
                'label' => 'dateEnd',
            ])
            ->add('file', FileType::class, [
                'attr' => [
                    'accept' => '.jpg,.jpeg,.png',
                    'class' => 'InputFileHidden',
                ],
                'label' => false,
                'mapped' => false,
                'required' => false,
            ])
            ->add('crop_x', HiddenType::class, [
                'mapped' => false,
            ])
            ->add('crop_y', HiddenType::class, [
                'mapped' => false,
            ])
            ->add('crop_width', HiddenType::class, [
                'mapped' => false,
            ])
            ->add('crop_height', HiddenType::class, [
                'mapped' => false,
            ])
            ->add('cropSave', HiddenType::class, [
                'mapped' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Banner::class
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_bannerbundle_banner';
    }
}
