<?php

namespace Wi\Admin\BlockBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\BlockBundle\Entity\Block;
use Wi\Admin\BlockBundle\Form\BlockDeleteType;
use Wi\Admin\BlockBundle\Form\BlockNewType;
use Wi\Admin\BlockBundle\Form\BlockType;

/**
 * Blocks controller.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BlocksController extends Controller
{
    /**
     * List all block entities.
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        // Pobranie grup stron.
        $blocks = $em->getRepository('WiAdminBlockBundle:Block')->findAll();

        return $this->render('WiAdminBlockBundle:Blocks:index.html.php', [
            'blocks' => $blocks,
        ]);
    }

    /**
     * Create a new block entity.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function newAction(Request $request)
    {
        // Utworzenie nowego obiektu strony.
        $block = new Block();

        // Generowanie formularza.
        $form = $this->createForm(BlockNewType::class, $block);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
           // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Zapis.
            $em->persist($block);
            $em->flush();

            return $this->redirectToRoute('wi_admin_block_show', [
                'id' => $block->getId(),
            ]);
        }

        return $this->render('WiAdminBlockBundle:Blocks:new.html.php', [
            'block' => $block,
            'form' => $form->createView(),
        ]);
    }

    /**
     * Displays a form to edit an existing block entity.
     *
     * @param Request $request
     * @param Block $block
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function editAction(Request $request, Block $block)
    {
        // Generowanie formularza.
        $form = $this->createForm(BlockType::class, $block);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Zapis.
            $em->persist($block);
            $em->flush();

            return $this->redirectToRoute('wi_admin_block_show', [
                'id' => $block->getId(),
            ]);
        }

        return $this->render('WiAdminBlockBundle:Blocks:edit.html.php', [
            'block' => $block,
            'edit_form' => $form->createView(),
        ]);
    }

    /**
     * Show a block entity.
     *
     * @param Block $block
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function showAction(Block $block)
    {
        return $this->render('WiAdminBlockBundle:Blocks:show.html.php', [
            'block' => $block,
        ]);
    }

    /**
     * Deletes a question entity.
     *
     * @param Request $request
     * @param Block $block
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function deleteAction(Request $request, Block $block)
    {
        // Generowanie formularza.
        $deleteForm = $this->createForm(BlockDeleteType::class);
        $deleteForm->handleRequest($request);

        // Weryfikacja czy formularz został przesłany i pomyślnie zwalidowany.
        if ($deleteForm->isSubmitted() && $deleteForm->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Usunięcie.
            $em->remove($block);
            $em->flush();

            return $this->redirectToRoute('wi_admin_block_index');
        }

        return $this->render('WiAdminBlockBundle:Blocks:delete.html.php', [
            'block' => $block,
            'deleteForm' => $deleteForm->createView(),
        ]);
    }
}
