<?php

namespace Wi\Admin\BannerBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\BlockBundle\Entity\Block;

/**
 * Załadowanie grup stron do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadBlockData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $block = $this->getBlock($data);
            $this->addReference('nb-block-'.$data['id'], $block);

            // Przygotowanie do zapisu.
            $manager->persist($block);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($block));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 11;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            [
                'id' => 1,
                'name' => 'Header',
                'status' => Block::STATUS_ACTIVE,
                'type' => Block::TYPE_TEMPLATE,
            ],
            [
                'id' => 2,
                'name' => 'Footer',
                'status' => Block::STATUS_ACTIVE,
                'type' => Block::TYPE_TEMPLATE,
            ],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\BlockBundle\Entity\Block
     */
    private function getBlock(array $data)
    {
        return (new Block())
            ->setId($data['id'])
            ->setName($data['name'])
            ->setStatus($data['status'])
            ->setType($data['type'])
        ;
    }
}
