<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_block_itemHTML_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.block.Edit')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/block.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.item.item'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_block_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.block.block'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_block_edit', array('id' => $block->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.block.Edit'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-doc-text-1"></i><?php echo $view['translator']->trans('block.listTitle'); ?> - <?php echo $view['translator']->trans('blockEdit.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('blockEdit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>

    <?php echo $view['form']->start($edit_form, ['attr' => ['id' => 'wi_admin_blockbundle_block']]); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-edit"></i> <span><?php echo $view['translator']->trans('blockEdit.boxTitle'); ?> - <?php echo $block->getName(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('blockNew.form.nameTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('blockNew.form.nameDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($edit_form['name']); ?>
                            </div>
                        <?php echo ($view['form']->errors($edit_form['name']) ? $view['form']->widget($edit_form['name'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($edit_form['name'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <div class="news-add-form">
                        <?php echo $view['form']->widget($edit_form); ?>
                        <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                            <i class="icon-edit"></i>
                            <?php echo $view['translator']->trans('Form.send'); ?>
                        </button>
                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_block_show', array('id' => $block->getId())); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php echo $view['form']->end($edit_form); ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/block.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
