<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_block_itemHTML_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.block.List')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/block.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.item.item'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_block_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.block.block'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-menu-outline"></i><?php echo $view['translator']->trans('block.listTitle'); ?> - <?php echo $view['translator']->trans('blockList.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('blockList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>

    <div class="box">
       <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowPages-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowPages-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_block_new'); ?>" title="<?php echo $view['translator']->trans('blockList.addNewBlock'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('blockList.addNewBlock'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-newspaper-1"></i>
                <span><?php echo $view['translator']->trans('blockList.listSubTitle')?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display:block;">
            <div class="row">
                <div class="columns tableResp">
                    <table id="itemHTMLGroupTable" class="blockList" style="width:100%">
                        <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('blockNew.form.nameTitle')?></th>
                            <th><?php echo $view['translator']->trans('blockList.itemList')?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($blocks as $block): ?>
                                <tr>
                                    <td><a href="<?php echo $view['router']->path('wi_admin_block_show', ['id' => $block->getId()]); ?>"><b><?php echo $block->getName(); ?></b></a>
                                        <div class="buttonItemsBox">
                                            <div class="buttonsItems">
                                                 <a href="<?php echo $view['router']->path('wi_admin_block_show', ['id' => $block->getId()]) ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton') ?></a>
                                                <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT')): ?>
                                                    <a href="<?php echo $view['router']->path('wi_admin_block_edit', ['id' => $block->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a>
                                                <?php endif; ?>
                                                <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT') & $block->getType()=='U'): ?>
                                                    <a href="<?php echo $view['router']->path('wi_admin_block_delete', ['id' => $block->getId()]); ?>" class=""><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton'); ?></a>
                                                <?php endif; ?>
                                            </div>
                                        </div></td>
                                    <td class="showItemBlock">
                                        <div class="tiny button-group">
                                            <?php foreach ($block->getItems() as $item): ?>
                                                <span class="info label secondary showItemButton"><?php echo $item->getName(); ?></span>
                                            <?php endforeach; ?>
                                        </div>
                                    </td>
                                </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row blockHTMLButton">
                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_block_itemHTML_index'); ?>">
                    <i class="icon-reply"></i><?php echo $view['translator']->trans('blockList.backButton'); ?>
                </a>
            </div>
        </div>
    </div>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/block.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
