<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_block_itemHTML_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.item.Edit')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css') ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/block.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.item.item'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_edit', array('id' => $itemHTML->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.item.Edit'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-doc-text-1"></i><?php echo $view['translator']->trans('item.listTitle'); ?> - <?php echo $view['translator']->trans('itemEdit.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('itemEdit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <?php echo $view['form']->start($edit_form, ['attr' => ['id' => 'wi_admin_blockbundle_itemHTML']]); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-edit"></i> <span><?php echo $view['translator']->trans('itemEdit.boxTitle'); ?> - <?php echo $itemHTML->getName(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('itemNew.form.nameTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('itemNew.form.nameDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($edit_form['name']); ?>
                            </div>
                        <?php echo ($view['form']->errors($edit_form['name']) ? $view['form']->widget($edit_form['name'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($edit_form['name'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('itemNew.form.dateStart'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('itemNew.form.dateStartDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($edit_form['dateStart']); ?>
                            </div>
                            <?php echo $view['form']->label($edit_form['dateStart']); ?>
                        <?php echo ($view['form']->errors($edit_form['dateStart']) ? $view['form']->widget($edit_form['dateStart'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($edit_form['dateStart'])); ?>
                        </div>
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($edit_form['dateEnd']); ?>
                            </div>
                            <?php echo $view['form']->label($edit_form['dateEnd']); ?>
                            <?php echo ($view['form']->errors($edit_form['dateEnd']) ? $view['form']->widget($edit_form['dateEnd'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($edit_form['dateEnd'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('itemEdit.form.textTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('itemEdit.form.textDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert <?php echo ($view['form']->errors($edit_form['content']) ? "callout alert" : ""); ?>">
                                <?php echo $view['form']->errors($edit_form['content']); ?>
                            </div>
                            <div class="formAlert callout alert" id="contentValidation">
                                <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                            </div>
                            <?php echo $view['form']->widget($edit_form['content']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <div class="news-add-form">
                        <?php echo $view['form']->widget($edit_form); ?>
                        <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                            <i class="icon-edit"></i>
                            <?php echo $view['translator']->trans('Form.send'); ?>
                        </button>
                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_block_itemHTML_show', array('id' => $itemHTML->getId())); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $view['form']->end($edit_form); ?>
<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js') ?>"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/block.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
