<?php

namespace Wi\Admin\ContactBundle\Controller;

use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\ContactBundle\Entity\Form;
use Wi\Admin\ContactBundle\Entity\FormMap;
use Wi\Admin\ContactBundle\Form\FormEditType;
use Wi\Admin\ContactBundle\Form\FormNewType;

/**
 * Contact controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ContactController extends Controller
{
    /**
     * Widok główny zarządzania formularzem kontaktowym.
     *
     * @param Form|null $currentForm
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Form $currentForm = null)
    {
        if (is_null($currentForm)) {
            $currentForm = $this->getFormRepository()->findFirst();
        }

        $em = $this->getDoctrine()->getManager();

        // Pobranie danych do Google Api Maps
        $GoogleapiKey = $em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => 'google',
                'name' => 'apiKey',
            ])
            ->getValue();

        $em->getFilters()->disable('softdeleteable');

        if (! is_null($currentForm)) {
            if (! is_null($currentForm->getPage())) {
                if (is_null($currentForm->getPage()->getDateDeleted())) {
                    $currentForm->setPage(null);
                }
            }
        }

        $em->getFilters()->enable('softdeleteable');
        $forms = $this->getFormRepository()->findBy([], ['name' => 'ASC']);
        $messagesCount = $em->getRepository('WiAdminContactBundle:Answer')->countAllByForm($currentForm);
        $unreadedMessagesCount = $em->getRepository('WiAdminContactBundle:Answer')->countUnreadedByForm($currentForm);

        return $this->render('WiAdminContactBundle:Contact:index.html.php', [
            'currentForm' => $currentForm,
            'forms' => $forms,
            'messagesCount' => $messagesCount,
            'unreadedMessagesCount' => $unreadedMessagesCount,
            'GoogleapiKey' => $GoogleapiKey,
        ]);
    }

    /**
     * Edycja formularza.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function editAction(Request $request, Form $Form)
    {
        $em = $this->getDoctrine()->getManager();

        // Pobranie danych do Google Api Maps
        $GoogleapiKey = $em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => 'google',
                'name' => 'apiKey',
            ])
            ->getValue();

        $em->getFilters()->disable('softdeleteable');

        if (! is_null($Form->getPage())) {
            if (! is_null($Form->getPage()->getDateDeleted())) {
                $Form->setPage(null);
            }
        }

        $em->getFilters()->enable('softdeleteable');

        if ($Form->getMaps()->count() == 0 && $Form->getType() == Form::TYPE_CONTACT) {
            $formMap = new FormMap();
            $Form->addMap($formMap);
        }

        $originalFields = new ArrayCollection();

        foreach ($Form->getFields() as $field) {
            $originalFields->add($field);
        }

        $form = $this->createForm(FormEditType::class, $Form);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $this->get('config')->save(
                'recaptcha',
                'siteKey',
                $form->get('siteKey')->getData()
            );
            $this->get('config')->save(
                'recaptcha',
                'secretKey',
                $form->get('secretKey')->getData()
            );

            $em = $this->getDoctrine()->getManager();

            foreach ($originalFields as $field) {
                if (false === $Form->getFields()->contains($field)) {
                    $field->getForm()->removeField($field);

                    $em->remove($field);
                }
            }

            $em->persist($Form);
            $em->flush();

            if ($form->get('save')->isClicked()) {
                return $this->redirectToRoute('wi_admin_contact_edit', [
                    'id' => $Form->getId(),
                ]);
            }
            return $this->redirectToRoute('wi_admin_contact_index_form', [
                'id' => $Form->getId(),
            ]);

        }

        return $this->render('WiAdminContactBundle:Contact:edit.html.php', [
            'form' => $form->createView(),
            'Form' => $Form,
            'GoogleapiKey' => $GoogleapiKey,
        ]);
    }

    /**
     * Dodawanie nowego formularza.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function newAction(Request $request)
    {
        $Form = new Form();
        $form = $this->createForm(FormNewType::class, $Form);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($Form);
            $em->flush();

            return $this->redirectToRoute('wi_admin_contact_index_form', [
                'id' => $Form->getId(),
            ]);
        }

        return $this->render('WiAdminContactBundle:Contact:new.html.php', [
            'form' => $form->createView(),
            'Form' => $Form,
        ]);
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera repozytorium formularzy kontaktowych.
     *
     * @return FormRepository
     */
    private function getFormRepository()
    {
        return $this
            ->getDoctrine()
            ->getManager()
            ->getRepository('WiAdminContactBundle:Form')
        ;
    }
}
