<?php

namespace Wi\Admin\ContactBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\ContactBundle\Entity\AnswerStatus;

/**
 * Załadowanie roli do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadAnswerStatusData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $answerStatus = $this->getAnswerStatus($data);
            $this->addReference('cb-answerStatus-'.$data['id'], $answerStatus);

            // Przygotowanie do zapisu.
            $manager->persist($answerStatus);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($answerStatus));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 52;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            ['id' => 1, 'group' => 'New', 'name' => 'New'],
            ['id' => 2, 'group' => 'In Progress', 'name' => 'Contact Initial'],
            ['id' => 3, 'group' => 'In Progress', 'name' => 'Sent Proposal'],
            ['id' => 4, 'group' => 'In Progress', 'name' => 'Meeting scheduled'],
            ['id' => 5, 'group' => 'Awaiting', 'name' => 'Waiting on Client'],
            ['id' => 6, 'group' => 'Awaiting', 'name' => 'Follow Up'],
            ['id' => 7, 'group' => 'Done - success', 'name' => 'Contracted'],
            ['id' => 8, 'group' => 'Finish - outdated', 'name' => 'Steal'],
            ['id' => 9, 'group' => 'Finish - outdated', 'name' => 'Refused'],
            ['id' => 10, 'group' => 'Finish - outdated', 'name' => 'Not Respond'],
            ['id' => 11, 'group' => 'Finish - outdated', 'name' => 'Spam'],
            ['id' => 12, 'group' => 'Finish - outdated', 'name' => 'Canceled'],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\ContactBundle\Entity\AnswerStatus
     */
    private function getAnswerStatus(array $data)
    {
        return (new AnswerStatus())
            ->setId($data['id'])
            ->setGroup($data['group'])
            ->setName($data['name'])
        ;
    }
}
