<?php

namespace Wi\Admin\ContactBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\ContactBundle\Entity\FormFieldType;

/**
 * Załadowanie roli do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadFormFieldTypeData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $formFieldType = $this->getFormFieldType($data);
            $this->addReference('cb-formFieldType-'.$data['id'], $formFieldType);

            // Przygotowanie do zapisu.
            $manager->persist($formFieldType);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($formFieldType));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 51;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            ['id' => 1, 'title' => 'Input (regular)', 'type' => 'text', 'identity' => false, 'class' => null, 'pattern' => null, 'patternTitle' => null],
            ['id' => 2, 'title' => 'Email', 'type' => 'email', 'identity' => true, 'class' => null, 'pattern' => null, 'patternTitle' => null],
            ['id' => 3, 'title' => 'Telephone', 'type' => 'tel', 'identity' => true, 'class' => null, 'pattern' => null, 'patternTitle' => null],
            ['id' => 4, 'title' => 'Message', 'type' => 'textarea', 'identity' => false, 'class' => null, 'pattern' => null, 'patternTitle' => null],
            ['id' => 5, 'title' => 'Checkbox', 'type' => 'checkbox', 'identity' => false, 'class' => null, 'pattern' => null, 'patternTitle' => null],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\ContactBundle\Entity\FormFieldType
     */
    private function getFormFieldType(array $data)
    {
        return (new FormFieldType())
            ->setId($data['id'])
            ->setTitle($data['title'])
            ->setType($data['type'])
            ->setIdentity($data['identity'])
            ->setClass($data['class'])
            ->setPattern($data['pattern'])
            ->setPatternTitle($data['patternTitle'])
        ;
    }
}
