<?php

namespace Wi\Admin\ContactBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Wi\Admin\ContactBundle\Entity\AnswerNote;
use Wi\Admin\ContactBundle\Entity\Form;
use Wi\Admin\ContactBundle\Entity\AnswerField;
use Wi\Admin\ContactBundle\Entity\AnswerStatus;
use Wi\Admin\ContactBundle\Entity\Form\FormFieldTypeInterface;

/**
 * Answer
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @ORM\Table(name="contact_answers")
 * @ORM\Entity(repositoryClass="Wi\Admin\ContactBundle\Repository\AnswerRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class Answer
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var Form
     *
     * @ORM\ManyToOne(targetEntity="\Wi\Admin\ContactBundle\Entity\Form")
     * @ORM\JoinColumn(name="form_id", referencedColumnName="id", nullable=false)
     */
    private $form;

    /**
     * @var AnswerStatus
     *
     * @ORM\ManyToOne(targetEntity="\Wi\Admin\ContactBundle\Entity\AnswerStatus")
     * @ORM\JoinColumn(name="status_id", referencedColumnName="id", nullable=false)
     */
    private $status;

    /**
     * @var bool
     *
     * @ORM\Column(name="mobile", type="boolean")
     */
    private $mobile;

    /**
     * @var string
     *
     * @ORM\Column(name="ip", type="string", length=32, nullable=true)
     */
    private $ip;

    /**
     * @var string
     *
     * @ORM\Column(name="host", type="string", length=256, nullable=true)
     */
    private $host;

    /**
     * @var string
     *
     * @ORM\Column(name="agent", type="string", length=256, nullable=true)
     */
    private $agent;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var ArrayCollection
     *
     * @ORM\OneToMany(targetEntity="Wi\Admin\ContactBundle\Entity\AnswerField", mappedBy="answer", cascade={"persist"})
     */
    private $fields;

    /**
     * @var ArrayCollection
     *
     * @ORM\OneToMany(targetEntity="Wi\Admin\ContactBundle\Entity\AnswerNote", mappedBy="answer", cascade={"persist"})
     */
    private $notes;


    // ------------------------------------------------------------
    // Has Lifecycle Callbacks methods.
    // ------------------------------------------------------------

    /**
     * Funkcja wykonuje się podczas wstawiania nowego rekordu do bazy.
     *
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        // Ustawienie daty utworzenia.
        $this->dateCreated = new \DateTime();
    }

    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set form
     *
     * @param Form $form
     * @return Answer
     */
    public function setForm(Form $form)
    {
        $this->form = $form;

        return $this;
    }

    /**
     * Get form
     *
     * @return Form
     */
    public function getForm()
    {
        return $this->form;
    }

    /**
     * Set status
     *
     * @param AnswerStatus $status
     * @return Answer
     */
    public function setStatus(AnswerStatus $status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return AnswerStatus
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set mobile
     *
     * @param boolean $mobile
     * @return Answer
     */
    public function setMobile($mobile)
    {
        $this->mobile = $mobile;

        return $this;
    }

    /**
     * Get mobile
     *
     * @return bool
     */
    public function getMobile()
    {
        return $this->mobile;
    }

    /**
     * Set ip
     *
     * @param string $ip
     * @return Answer
     */
    public function setIp($ip)
    {
        $this->ip = $ip;

        return $this;
    }

    /**
     * Get ip
     *
     * @return string
     */
    public function getIp()
    {
        return $this->ip;
    }

    /**
     * Set host
     *
     * @param string $host
     * @return Answer
     */
    public function setHost($host)
    {
        $this->host = $host;

        return $this;
    }

    /**
     * Get host
     *
     * @return string
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * Set agent
     *
     * @param string $agent
     * @return Answer
     */
    public function setAgent($agent)
    {
        $this->agent = $agent;

        return $this;
    }

    /**
     * Get agent
     *
     * @return string
     */
    public function getAgent()
    {
        return $this->agent;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     * @return Answer
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Add field
     *
     * @param AnswerField $field
     * @return Answer
     */
    public function addField(AnswerField $field)
    {
        $field->setAnswer($this);
        $this->fields[] = $field;

        return $this;
    }

    /**
     * Remove field
     *
     * @param AnswerField $field
     */
    public function removeField(AnswerField $field)
    {
        $this->fields->removeElement($field);
    }

    /**
     * Get fields
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFields()
    {
        return $this->fields;
    }

    /**
     * Add note
     *
     * @param AnswerNote $note
     * @return Answer
     */
    public function addNote(AnswerNote $note)
    {
        $note->setAnswer($this);
        $this->notes[] = $note;

        return $this;
    }

    /**
     * Remove note
     *
     * @param AnswerNote $note
     */
    public function removeNote(AnswerNote $note)
    {
        $this->notes->removeElement($note);
    }

    /**
     * Get notes
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getNotes()
    {
        return $this->notes;
    }

    // ------------------------------------------------------------
    // Methods.
    // ------------------------------------------------------------

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->fields = new ArrayCollection();
        $this->notes = new ArrayCollection();
    }

    /**
     * Pola odpowiedzi oznaczone jako identity.
     *
     * @return array
     */
    public function getIdentityFields()
    {
        $arr = [];

        foreach ($this->fields as $field) {
            if ($field->getField()->getIdentity()) {
                $arr[$field->getField()->getLabel()] = $field;
            }
        }

        return $arr;
    }

    /**
     * Pola odpowiedzi nie oznaczone jako identity.
     *
     * @return array
     */
    public function getMessagesFields()
    {
        $arr = [];

        foreach ($this->fields as $field) {
            if (! $field->getField()->getIdentity()) {
                $arr[$field->getField()->getLabel()] = $field;
            }
        }

        return $arr;
    }

    /**
     * Zwraca ostatni dodane komentarz.
     *
     * @return AnswerNote
     */
    public function getLastNote()
    {
        return $this->notes->last();
    }

    /**
     * Pobiera istniejący e-mail z listy pól.
     *
     * @return string|bool
     */
    public function getEmail()
    {
        foreach ($this->fields as $field) {
            if ($field->getField()->getFormFieldType()->getType() == FormFieldTypeInterface::INPUT_EMAIL) {
                return $field->getFieldValue();
            }
        }

        return false;
    }
}
