<?php

namespace Wi\Admin\ContactBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FormFieldType
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @ORM\Table(name="contact_formFieldTypes")
 * @ORM\Entity(repositoryClass="Wi\Admin\ContactBundle\Repository\FormFieldTypeRepository")
 */
class FormFieldType
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="title", type="string", length=45)
     */
    private $title;

    /**
     * @var string
     *
     * @ORM\Column(name="type", type="string", length=45)
     */
    private $type;

    /**
     * @var string
     *
     * @ORM\Column(name="class", type="string", length=255, nullable=true)
     */
    private $class;

    /**
     * @var string
     *
     * @ORM\Column(name="pattern", type="string", length=255, nullable=true)
     */
    private $pattern;

    /**
     * @var string
     *
     * @ORM\Column(name="patternTitle", type="string", length=255, nullable=true)
     */
    private $patternTitle;

    /**
     * @var bool
     *
     * @ORM\Column(name="identity", type="boolean")
     */
    private $identity;


    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Set id
     *
     * @param int $id
     * @return FormFieldType
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return FormFieldType
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set type
     *
     * @param string $type
     * @return FormFieldType
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set class
     *
     * @param string $class
     * @return FormFieldType
     */
    public function setClass($class)
    {
        $this->class = $class;

        return $this;
    }

    /**
     * Get class
     *
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }

    /**
     * Set pattern
     *
     * @param string $pattern
     * @return FormFieldType
     */
    public function setPattern($pattern)
    {
        $this->pattern = $pattern;

        return $this;
    }

    /**
     * Get pattern
     *
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }

    /**
     * Set patternTitle
     *
     * @param string $patternTitle
     * @return FormFieldType
     */
    public function setPatternTitle($patternTitle)
    {
        $this->patternTitle = $patternTitle;

        return $this;
    }

    /**
     * Get patternTitle
     *
     * @return string
     */
    public function getPatternTitle()
    {
        return $this->patternTitle;
    }

    /**
     * Set identity
     *
     * @param boolean $identity
     * @return FormFieldType
     */
    public function setIdentity($identity)
    {
        $this->identity = $identity;

        return $this;
    }

    /**
     * Get identity
     *
     * @return bool
     */
    public function getIdentity()
    {
        return $this->identity;
    }
}
