<?php

namespace Wi\Admin\ContactBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Wi\Admin\ContactBundle\Entity\Form;

/**
 * FormMap
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @ORM\Table(name="contact_formMaps")
 * @ORM\Entity(repositoryClass="Wi\Admin\ContactBundle\Repository\FormMapRepository")
 */
class FormMap
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var Form
     *
     * @ORM\ManyToOne(targetEntity="\Wi\Admin\ContactBundle\Entity\Form", inversedBy="maps")
     * @ORM\JoinColumn(name="form_id", referencedColumnName="id", nullable=false)
     */
    private $form;

    /**
     * @var bool
     *
     * @ORM\Column(name="customMap", type="boolean")
     */
    private $customMap;

    /**
     * @var string
     *
     * @ORM\Column(name="embeded", type="string", length=1023, nullable=true)
     */
    private $embeded;

    /**
     * @var string
     *
     * @ORM\Column(name="lat", type="string", length=25, nullable=true)
     */
    private $lat;

    /**
     * @var string
     *
     * @ORM\Column(name="lng", type="string", length=25, nullable=true)
     */
    private $lng;

    /**
     * @var int
     *
     * @ORM\Column(name="zoom", type="integer", nullable=true)
     */
    private $zoom;

    /**
     * @var string
     *
     * @ORM\Column(name="windowInfo", type="text", nullable=true)
     */
    private $windowInfo;

    /**
     * @var int
     *
     * @ORM\Column(name="orderNr", type="integer", nullable=true)
     */
    private $orderNr;

    /**
     * @var string
     *
     * @ORM\Column(name="pin", type="string", length=255, nullable=true)
     */
    private $pin;


    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set form
     *
     * @param Form $form
     * @return FormField
     */
    public function setForm(Form $form)
    {
        $this->form = $form;

        return $this;
    }

    /**
     * Get form
     *
     * @return Form
     */
    public function getForm()
    {
        return $this->form;
    }

    /**
     * Set customMap
     *
     * @param boolean $customMap
     * @return FormMap
     */
    public function setCustomMap($customMap)
    {
        $this->customMap = $customMap;

        return $this;
    }

    /**
     * Get customMap
     *
     * @return bool
     */
    public function getCustomMap()
    {
        return $this->customMap;
    }

    /**
     * Set embeded
     *
     * @param string $embeded
     * @return FormMap
     */
    public function setEmbeded($embeded)
    {
        $this->embeded = $embeded;

        return $this;
    }

    /**
     * Get embeded
     *
     * @return string
     */
    public function getEmbeded()
    {
        return $this->embeded;
    }

    /**
     * Set lat
     *
     * @param string $lat
     * @return FormMap
     */
    public function setLat($lat)
    {
        $this->lat = $lat;

        return $this;
    }

    /**
     * Get lat
     *
     * @return string
     */
    public function getLat()
    {
        return $this->lat;
    }

    /**
     * Set lng
     *
     * @param string $lng
     * @return FormMap
     */
    public function setLng($lng)
    {
        $this->lng = $lng;

        return $this;
    }

    /**
     * Get lng
     *
     * @return string
     */
    public function getLng()
    {
        return $this->lng;
    }

    /**
     * Set zoom
     *
     * @param integer $zoom
     * @return FormMap
     */
    public function setZoom($zoom)
    {
        $this->zoom = $zoom;

        return $this;
    }

    /**
     * Get zoom
     *
     * @return int
     */
    public function getZoom()
    {
        return $this->zoom;
    }

    /**
     * Set windowInfo
     *
     * @param string $windowInfo
     * @return FormMap
     */
    public function setWindowInfo($windowInfo)
    {
        $this->windowInfo = $windowInfo;

        return $this;
    }

    /**
     * Get windowInfo
     *
     * @return string
     */
    public function getWindowInfo()
    {
        return $this->windowInfo;
    }

    /**
     * Set orderNr
     *
     * @param integer $orderNr
     * @return FormMap
     */
    public function setOrderNr($orderNr)
    {
        $this->orderNr = $orderNr;

        return $this;
    }

    /**
     * Get orderNr
     *
     * @return int
     */
    public function getOrderNr()
    {
        return $this->orderNr;
    }

    /**
     * Set pin
     *
     * @param string $pin
     * @return FormMap
     */
    public function setPin($pin)
    {
        $this->pin = $pin;

        return $this;
    }

    /**
     * Get pin
     *
     * @return string
     */
    public function getPin()
    {
        return $this->pin;
    }
}
