<?php

namespace Wi\Admin\ContactBundle\Form;

use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\ContactBundle\Entity\FormMap;

/**
 * Form map type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class FormMapType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('customMap', null, [
                'attr' => [
                    'class' => 'switch-input switchMapsGenerator'
                ],
                'label' => false
            ])
            ->add('embeded', TextType::class, [
                'attr' => [
                    'class' => 'urlGoogleMaps',
                ],
                'required' => false,
                'label' => false
            ])
            ->add('windowInfo', TextareaType::class, [
                'attr' => [
                    'class' => 'tinyBasicEditor textareaPinWindow pinWindowShow',
                ],
                'required' => false,
                'label' => false,
            ])
            ->add('lat', HiddenType::class, [
                'attr' => [
                    'class' => 'latMaps',
                ],
                'required' => false,
            ])
            ->add('lng', HiddenType::class, [
                'attr' => [
                    'class' => 'lngMaps',
                ],
                'required' => false,
            ])
            ->add('zoom', HiddenType::class, [
                'attr' => [
                    'class' => 'zoomMaps',
                ],
                'required' => false,
            ])
            ->add('orderNr', HiddenType::class, [
                'attr' => [
                    'class' => 'orderNrMaps',
                ],
                'required' => false,
            ])
            ->add('pin', HiddenType::class, [
                'attr' => [
                    'class' => 'pinMaps',
                ],
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => FormMap::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_contactbundle_form_map';
    }
}
