<?php $view->extend('::wicms.html.php') ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_contact_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.contact.index')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/contact.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_contact_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.contact.index'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-post"></i><?php echo $view['translator']->trans('contact.title'); ?> <?php echo ! is_null($currentForm) ? ' - '.$currentForm->getName() : ''; ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('contact.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script async defer src="https://maps.googleapis.com/maps/api/js?key=<?php echo $GoogleapiKey; ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/contact.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('menuShowSite'); ?>
    <?php if(! is_null($currentForm)): ?>
        <div class="menu-show-site">
            <a  class="button warning tiny" href="<?php echo $view['router']->path('wi_front_contact_index_2', ['id' => $currentForm->getId(), 'slug' => $view['front']->slugify($currentForm->getName())]); ?>" title="<?php echo $view['translator']->trans('top-bar.showArticle'); ?>" target="_blank">
                <i class="icon-monitor-1"></i>
                <span>
                    <?php echo $view['translator']->trans('top-bar.showArticle'); ?>
                </span>
            </a>
        </div>
    <?php endif; ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowContact-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
            <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowContact-dropdown" data-dropdown data-close-on-click="true">
                <ul class="no-bullet">
                    <li>
                        <?php if ($view['security']->isGranted('ROLE_CONTACT_EDIT')): ?>
                            <?php if (! is_null($currentForm)): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_contact_edit', ['id' => $currentForm->getId()]); ?>" title="<?php echo $view['translator']->trans('contactIndex.edit'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('contactIndex.edit'); ?></span>
                                </a>
                            <?php endif ?>
                        <?php endif; ?>
                    </li>
                    <li>
                        <?php if ($view['security']->isGranted('ROLE_CONTACT_EDIT')): ?>
                            <a href="<?php echo $view['router']->path('wi_admin_contact_new'); ?>">
                                <span><i class="icon-list-add"></i><?php echo $view['translator']->trans('contactIndex.addNew'); ?></span>
                            </a>
                        <?php endif; ?>
                    </li>
                </ul>
            </div>
        </div>
        <h3 class="box-title"><i class="icon-mail"></i>
            <span><?php echo $view['translator']->trans('contactIndex.titleChoseForm'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body bodyChangeForm" style="display: block;">
        <div class="row">
            <div class="columns medium-8 large-6">
                <div class="activFormChange <?php echo $forms ? 'activeMoreButton" data-toggle="moreForm"' : '"' ?>>
                    <h6><?php echo ! is_null($currentForm) ? $currentForm->getName() : $view['translator']->trans('contactIndex.nullForm'); ?></h6>
                </div>
                <div class="dropdown-pane moreForm" data-position="bottom" data-alignment="left" id="moreForm" data-dropdown data-auto-focus="false" data-close-on-click="true">
                    <?php foreach ($forms as $form): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_contact_index_form', ['id' => $form->getId()]); ?>" class="<?php echo (! is_null($currentForm) && $form->getId() == $currentForm->getId()) ? 'active' : ''; ?>"><?php echo $form->getName(); ?></a><br>
                    <?php endforeach ?>
                </div>
            </div>
            <div class="columns medium-4 large-6">
                <?php if(! is_null($currentForm)): ?>
                    <div class="row">
                        <div class="columns small-6 medium-4">
                            <div class="newMessages">
                                <?php echo $view['translator']->trans('contactIndex.newMessages'); ?>:
                                <strong><?php echo $unreadedMessagesCount; ?></strong>
                            </div>
                            <div class="allMessages">
                                <?php echo $view['translator']->trans('contactIndex.allMessages'); ?>:
                                <strong><?php echo $messagesCount; ?></strong>
                            </div>
                        </div>
                        <div class="columns small-6 medium-8">
                            <a href="<?php echo $currentForm->getType() == 'C' ? $view['router']->path('wi_admin_contact_messages', ['id' => $currentForm->getId()]) : $view['router']->path('wi_admin_contact_leads_form', ['id' => $currentForm->getId()]); ?>" class="inboxMessages button">
                                <i class="icon-inbox-3"></i>
                                <span>
                        <?php echo $view['translator']->trans('contactIndex.inboxMessages'); ?>
                    </span>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php if(! is_null($currentForm)): ?>
    <?php if($currentForm->getType() == 'C'): ?>
        <div class="box">
            <div class="box-header bg-transparent">
                <!-- tools box -->

                <div class="pull-right box-tools">
                    <span class="box-btn" data-toggle="configArticle-dropdown">
                        <i class="icon-cog-5"></i>
                    </span>
                    <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configArticle-dropdown" data-dropdown data-close-on-click="true">
                        <ul class="no-bullet">
                            <li>
                                <?php if (! is_null($currentForm->getPage())): ?>
                                    <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_pages_edit', ['id' => $currentForm->getPage()->getId(), 'urlBack' => $view['router']->path('wi_admin_contact_index_form', ['id' => $currentForm->getId()])]); ?>" title="<?php echo $view['translator']->trans('contactIndex.editArticle'); ?>">
                                            <span><i class="icon-edit"></i><?php echo $view['translator']->trans('contactIndex.editArticle'); ?></span>
                                        </a>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <?php if ($view['security']->isGranted('ROLE_CONTACT_EDIT')): ?>
                                        <?php if (! is_null($currentForm)): ?>
                                            <a href="<?php echo $view['router']->path('wi_admin_contact_edit', ['id' => $currentForm->getId()]); ?>" title="<?php echo $view['translator']->trans('contactIndex.edit'); ?>">
                                                <span><i class="icon-edit"></i><?php echo $view['translator']->trans('contactIndex.edit'); ?></span>
                                            </a>
                                        <?php endif ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </li>
                        </ul>
                    </div>
                </div>

                <h3 class="box-title"><i class="icon-doc-text"></i>
                    <span><?php echo $view['translator']->trans('contactIndex.titleArticle'); ?></span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body " style="display: block;">
                <div class="row">
                    <div class="columns">
                        <?php if (! is_null($currentForm->getPage())): ?>
                            <div class="titleSmall">
                                <?php echo $view['translator']->trans('contactIndex.articleTitle'); ?>:
                            </div>
                            <div class="titleArticleShow callout small">
                                <h6>
                                    <?php echo $currentForm->getPage()->getTitle(); ?>
                                </h6>
                            </div>
                            <div class="titleSmall">
                                <?php echo $view['translator']->trans('contactIndex.articleContent'); ?>:
                            </div>
                            <div class="contentArticleShow callout">
                                <?php echo $currentForm->getPage()->getContent(); ?>
                            </div>
                        <?php else: ?>
                            <div class="contentArticleShow callout">
                                <?php echo $view['translator']->trans('contactIndex.pageNull'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <?php if($currentForm->getType() == 'C'): ?>
        <div class="box">
            <div class="box-header bg-transparent">
                <!-- tools box -->
                <h3 class="box-title"><i class="icon-location"></i>
                    <span><?php echo $view['translator']->trans('contactIndex.titleMaps'); ?></span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body " style="display: block;">
                <div class="row">
                    <div class="columns">
                        <div class="mapGoogleView float-center">
                            <?php foreach ($currentForm->getMaps() as $key=>$map): ?>
                                <?php if ($map->getCustomMap()): ?>
                                    <div class="pinWindowShow hide">
                                        <?php echo $map->getWindowInfo(); ?>
                                    </div>
                                    <div class="googlemaps text-center responsive-embed float-center" id="googleMaps" data-lat="<?php echo $map->getLat() ? $map->getLat() : '50'; ?>" data-lng="<?php echo $map->getLng() ? $map->getLng() : '21'; ?>" data-zoom="<?php echo $map->getZoom() ? $map->getZoom() : '11'; ?>"></div>
                                <?php else: ?>
                                    <div class="googlemapsembed float-center">
                                        <?php echo $map->getEmbeded(); ?>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <div class="row">
        <div class="columns small-12 medium-12 large-6">
            <div class="box previewFormBox">
                <div class="box-header bg-transparent">
                    <!-- tools box -->
                    <h3 class="box-title"><i class="icon-doc-text-inv-1"></i>
                        <span><?php echo $view['translator']->trans('contactIndex.formTitle'); ?></span>
                    </h3>
                </div>
                <!-- /.box-header -->
                <div class="box-body " style="display: block;">
                    <div class="row padding15">
                        <div class="columns">
                           <div class="titleSmall">
                               <?php echo $view['translator']->trans('contactIndex.emailRecipiens'); ?>:
                           </div>
                            <div class="callout small">
                                <?php echo $currentForm->getRecipients(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="row marginBottomNull">
                        <div class="columns">
                            <div class="previewReplayBox">
                                <div class="titleSmall">
                                    <?php echo $view['translator']->trans('contactEdit.formPreview'); ?>:
                                </div>
                                <div class="previewForm">
                                    <?php foreach ($currentForm->getFields() as $field): ?>
                                        <?php $type = $field->getFormFieldType()->getType(); ?>
                                        <?php $label = $field->getLabel(); ?>
                                        <?php $value = $field->getValue(); ?>
                                        <?php $place = $field->getPlaceholder(); ?>
                                        <?php $requ = $field->getRequired(); ?>

                                        <div class="row">
                                            <?php if ($type == 'textarea'): ?>
                                                <div class="columns">
                                                    <label>
                                                        <?php echo $label; ?><?php echo $requ==true ? '*' : ''; ?>
                                                    </label>
                                                </div>
                                                <div class="columns">
                                                    <textarea rows="4" cols="50" placeholder="<?php echo $place; ?>">
                                                        <?php echo $value; ?>
                                                    </textarea>
                                                </div>
                                            <?php else: ?>
                                                <div class="columns small-5 medium-2">
                                                    <label>
                                                        <?php echo $label; ?><?php echo $requ==true ? '*' : ''; ?>
                                                    </label>
                                                </div>
                                                <div class="columns small-7 medium-10">
                                                    <input type="<?php echo $type; ?>" placeholder="<?php echo $place; ?>">
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="columns small-12 medium-12 large-6">
            <div class="box previewFormBox">
                <div class="box-header bg-transparent">
                    <!-- tools box -->
                    <h3 class="box-title"><i class="icon-retweet"></i>
                        <span><?php echo $view['translator']->trans('contactIndex.replayTitle'); ?></span>
                    </h3>
                </div>
                <!-- /.box-header -->
                <div class="box-body " style="display: block;">
                    <div class="row padding15">
                        <div class="columns medium-4">
                            <div class="titleSmall"><?php echo $view['translator']->trans('contactEdit.replayLabel'); ?></div>
                            <div class="switch-admin editFormSwitch">
                                <input class="switch-input" id="replaySwitch" type="checkbox" name="exampleSwitch" <?php echo empty($currentForm->getAutoreply()) ? '' : 'checked'; ?> disabled>
                                <label class="switch-paddle" for="replaySwitch">
                                    <span class="show-for-sr"><?php echo $view['translator']->trans('contactEdit.replayLabel'); ?></span>
                                    <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                    <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                                </label>
                            </div>
                        </div>
                        <div class="columns medium-8">
                            <div class="contentReplay <?php echo ! empty($currentForm->getAutoreply()) ? '' : 'hide'; ?>">
                                <div class="titleSmall">
                                    <?php echo $view['translator']->trans('contactEdit.replySubject'); ?>
                                </div>
                                <div class="callout small">
                                    <?php echo $currentForm->getReplySubject(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row marginBottomNull">
                        <div class="columns">
                            <div class="contentReplay <?php echo ! empty($currentForm->getAutoreply()) ? '' : 'hide'; ?>">
                                <div class="previewReplayBox">
                                    <div class="titleSmall">
                                        <?php echo $view['translator']->trans('contactEdit.emailPreview'); ?>:
                                    </div>
                                    <div class="previewReplay">
                                        <?php echo $currentForm->getReplyMessage(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php $view['slots']->stop() ?>
