<?php

namespace Wi\Admin\CoreBundle\Cache;

use Psr\Cache\CacheItemPoolInterface;

/**
 * Cache WiCMS Config Manager.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class CacheConfigManager
{
    /**
     * Klucz pod jakim znajdują się dane.
     *
     * @const KEY
     */
    private const KEY = 'wicms_config';

    // -------------------------------------------------------------------------

    /**
     * @var CacheItemPoolInterface
     */
    private $cache;

    /**
     * Constructor.
     *
     * @param CacheItemPoolInterface $cache
     */
    public function __construct(CacheItemPoolInterface $cache)
    {
        $this->cache = $cache;
        $this->item = $cache->getItem(self::KEY);
    }

    /**
     * Sprawdza, czy istnieje cache.
     *
     * @return bool
     */
    public function isHit() : bool
    {
        return $this->item->isHit();
    }

    /**
     * Ustawia dane cache. Zapisuje cache.
     *
     * @param array
     * @return bool
     */
    public function set($value)
    {
        $this->item->set($value);

        return $this->save();
    }

    /**
     * Zapisuje cache.
     *
     * @return array
     */
    public function get()
    {
        return $this->item->get();
    }

    /**
     * Zapisuje cache.
     *
     * @return bool
     */
    public function save()
    {
        return $this->cache->save($this->item);
    }

    /**
     * Czyści cache.
     *
     * @return bool
     */
    public function clear()
    {
        return $this->cache->deleteItem(self::KEY);
    }
}
