<?php

namespace Wi\Admin\CoreBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class UpdateDatabaseCommand extends ContainerAwareCommand
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('app:doctrine:core:update-database')
            ->setDescription('Aktualizacja struktury i import danych do bazy.')
            ->setHelp('Wykonuje polecenia doctrine:schema:update -f, doctrine:fixtures:load -n, app:doctrine:newsletter:drop-view, app:doctrine:newsletter:create-view, app:doctrine:core:drop-table-menu')
        ;
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln(['', 'Rozpoczęcie importu.', '']);

        $appDoctrineNewsletterDropView = $this->getApplication()->find('app:doctrine:newsletter:drop-view');
        $appDoctrineNewsletterCreateView = $this->getApplication()->find('app:doctrine:newsletter:create-view');
        $appDoctrineCoreDropTableMenu = $this->getApplication()->find('app:doctrine:core:drop-table-menu');
        $doctrineFixturesLoad = $this->getApplication()->find('doctrine:fixtures:load');
        $doctrineSchemaUpdate = $this->getApplication()->find('doctrine:schema:update');

        $output->writeln(['']);

        $return = $appDoctrineNewsletterDropView->run(new ArrayInput([
            'command' => 'app:doctrine:newsletter:drop-view',
        ]), $output);

        $output->writeln(['']);

        $return = $appDoctrineCoreDropTableMenu->run(new ArrayInput([
            'command' => 'app:doctrine:core:drop-table-menu',
        ]), $output);

        $output->writeln(['']);

        $return = $doctrineSchemaUpdate->run(new ArrayInput([
            'command' => 'doctrine:schema:update',
            '--force' => true,
        ]), $output);

        $output->writeln(['']);

        $return = $doctrineFixturesLoad->run(new ArrayInput([
            'command' => 'doctrine:fixtures:load',
            '--no-interaction' => true,
        ]), $output);

        $output->writeln(['']);

        $return = $appDoctrineNewsletterCreateView->run(new ArrayInput([
            'command' => 'app:doctrine:newsletter:create-view',
        ]), $output);
    }
}
