<?php

namespace Wi\Admin\CoreBundle\Controller;

use Knp\Component\Pager\Paginator;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\CoreBundle\Form\Config\BlogType;
use Wi\Admin\CoreBundle\Form\Config\CommentType;
use Wi\Admin\CoreBundle\Form\Config\ContactType;
use Wi\Admin\CoreBundle\Form\Config\CookieType;
use Wi\Admin\CoreBundle\Form\Config\GAType;
use Wi\Admin\CoreBundle\Form\Config\MetaDataType;
use Wi\Admin\CoreBundle\Form\Config\NewsType;
use Wi\Admin\CoreBundle\Form\Config\UserType;
use Wi\Admin\CoreBundle\Form\ConfigValueType;
use Google_Service_Analytics;

/**
 * Config controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ConfigController extends Controller
{
    /**
     * Widok konfiguracji.
     *
     * @param Paginator $paginator
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Paginator $paginator, Request $request)
    {
        $configuration = $this->getConfigRepo()->findBy([], [
            'groupName' => 'ASC',
            'name' => 'ASC',
        ]);
        $configurationArchive = $paginator->paginate(
            $this->getConfigRepo()->findAllArchive(),
            $request->query->getInt('page', 1),
            $request->query->getInt('per_page') ?: 10
        );

        $form = $this->createForm(ConfigValueType::class);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $config = $this->getConfigRepo()->find((int) $form->get('id')->getData());

            if (! is_null($config)) {
                $this->get('config')->save(
                    $config->getGroupName(),
                    $config->getName(),
                    $form->get('value')->getData()
                );
            }

            return $this->redirectToRoute('wi_admin_core_config_index');
        }

        return $this->render('WiAdminCoreBundle:Config:index.html.php', [
            'configuration' => $configuration,
            'configurationArchive' => $configurationArchive,
            'form' => $form->createView(),
        ]);
    }

    /**
     * Konfiguracja aktualności.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function newsAction(Request $request)
    {
        $form = $this->createForm(NewsType::class);
        $form->handleRequest($request);

        $formBlog = $this->createForm(BlogType::class);
        $formBlog->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();

            foreach ($data as $config => $value) {
                $arr = explode('_', $config);

                $this->get('config')->save(
                    $arr[0],
                    $arr[1],
                    $value
                );
            }

            return $this->redirectToRoute('wi_admin_core_config_news');
        }



        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($formBlog->isSubmitted() && $formBlog->isValid()) {
            $data = $formBlog->getData();

            foreach ($data as $config => $value) {
                $arr = explode('_', $config);

                $this->get('config')->save(
                    $arr[0],
                    $arr[1],
                    $value
                );
            }

            return $this->redirectToRoute('wi_admin_core_config_news');
        }

        return $this->render('WiAdminCoreBundle:Config:news.html.php', [
            'form' => $form->createView(),
            'formBlog' => $formBlog->createView(),
        ]);
    }

    /**
     * Konfiguracja metadanych.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function metadataAction(Request $request)
    {
        $form = $this->createForm(MetaDataType::class);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();

            foreach ($data as $config => $value) {
                $arr = explode('_', $config);

                if (in_array($arr[1], [
                    'titleForAllPages',
                    'keywordsEnable',
                    'keywordsForAllPages',
                    'openGraphEnable',
                    'canonical',
                    'canonicalForce'
                ])) {
                    $value = intval($value);
                }

                $this->get('config')->save(
                    $arr[0],
                    $arr[1],
                    $value
                );
            }

            return $this->redirectToRoute('wi_admin_core_config_metadata');
        }

        return $this->render('WiAdminCoreBundle:Config:metadata.html.php', [
            'form' => $form->createView(),
        ]);
    }

    public function contactAction(Request $request)
    {
        $form = $this->createForm(ContactType::class);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();

            foreach ($data as $config => $value) {
                $arr = explode('_', $config);

                $this->get('config')->save(
                    $arr[0],
                    $arr[1],
                    $value
                );
            }

            return $this->redirectToRoute('wi_admin_core_config_contact');
        }

        return $this->render('WiAdminCoreBundle:Config:contact.html.php', [
            'form' => $form->createView(),
        ]);
    }

    public function gaAction(Request $request)
    {

        $form = $this->createForm(GAType::class);
        $form->handleRequest($request);

        $em = $this->getDoctrine()->getManager();

        // Pobranie danych do Google Api Analytics
        $viewId = $em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => 'google',
                'name' => 'gaViewId',
            ])
            ->getValue();

        $gaJson = $em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => 'google',
                'name' => 'gaJson',
            ])
            ->getValue();

        // Utoworzenie obiektu sesji.
        $session = $request->getSession();

        // Logowanie do Google Api
        if (! is_null($gaJson)){
            $client = new \Google_Client();
            $client->setAuthConfig($this->getParameter('web_dir').'/ga/'.$gaJson);
            $client->addScope(Google_Service_Analytics::ANALYTICS_READONLY);

            $googleTokenSession = $session->get('googleToken');
            if($googleTokenSession){
                $client->setAccessToken($googleTokenSession);
            }
            if ($client->isAccessTokenExpired()) {
                $client->fetchAccessTokenWithAssertion();
            }
            $googleToken = $client->getAccessToken();
            $session->set('googleToken', $googleToken);
        } else {
            $googleToken = null;
        }

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();

            foreach ($data as $config => $value) {
                if($config == 'google_gaJson'){
                    if(! is_null($value)){
                        $file = $form['google_gaJson']->getData();
                        $fileName = $file->getClientOriginalName();
                        $fileType = $file->getClientMimeType();
                        if($fileType == 'application/octet-stream'){
                            $file->move($this->getParameter('web_dir').'/ga/', $fileName);
                            $this->get('config')->save(
                                'google',
                                'gaJson',
                                $fileName
                            );
                        }
                    }
                } else {
                    $arr = explode('_', $config);

                    $this->get('config')->save(
                        $arr[0],
                        $arr[1],
                        $value
                    );
                }
            }

            return $this->redirectToRoute('wi_admin_core_config_ga');
        }


        return $this->render('WiAdminCoreBundle:Config:ga.html.php', [
            'form' => $form->createView(),
            'gaViewId' => $viewId,
            'gaJson' => $gaJson,
            'googleToken' => $googleToken['access_token'],
        ]);
    }

    /**
     * Konfiguracja Cookie.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function cookieAction(Request $request)
    {
        $form = $this->createForm(CookieType::class);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();

            foreach ($data as $config => $value) {
                $arr = explode('_', $config);

                if (in_array($arr[1], [
                    'enable',
                ])) {
                    $value = intval($value);
                }

                $this->get('config')->save(
                    $arr[0],
                    $arr[1],
                    $value
                );
            }

            return $this->redirectToRoute('wi_admin_core_config_cookie');
        }

        return $this->render('WiAdminCoreBundle:Config:cookie.html.php', [
            'form' => $form->createView(),
        ]);
    }

    public function commentAction(Request $request)
    {
        $form = $this->createForm(CommentType::class);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();

            foreach ($data as $config => $value) {
                $arr = explode('_', $config);

                if (in_array($arr[1], [
                    'enableLoginButton',
                    'enableUserAutoAccept',
                    'enableGuestAutoAccept',
                    'enableGuest',
                    'enableUserLimit',
                    'userLimitValue',
                    'enableGuestLimit',
                ])) {
                    $value = intval($value);
                }

                $this->get('config')->save(
                    $arr[0],
                    $arr[1],
                    $value
                );
            }

            return $this->redirectToRoute('wi_admin_core_config_comment');
        }

        return $this->render('WiAdminCoreBundle:Config:comment.html.php', [
            'form' => $form->createView(),
        ]);
    }

    /**
     * Edycja ustawień polityki użytkowników w serwisie.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function userAction(Request $request)
    {
        $form = $this->createForm(UserType::class);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();

            foreach ($data as $config => $value) {
                $arr = explode('_', $config);

                if (in_array($arr[1], [
                    'autoAccept',
                    'confirmEmail',
                    'notifyAdmin',
                ])) {
                    $value = intval($value);
                }

                if (in_array($arr[1], [
                    'notifyAdminList',
                ])) {
                    $tmp = [];

                    foreach ($value as $adm) {
                        $tmp[] = $adm->getId();
                    }

                    $value = implode(',', $tmp);
                }

                $this->get('config')->save(
                    $arr[0],
                    $arr[1],
                    $value
                );
            }

            return $this->redirectToRoute('wi_admin_core_config_user');
        }

        return $this->render('WiAdminCoreBundle:Config:user.html.php', [
            'form' => $form->createView(),
        ]);
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera repozytorium konfiguracji.
     *
     * @return ConfigRepository
     */
    private function getConfigRepo()
    {
        return $this->getDoctrine()->getManager()
            ->getRepository('WiAdminCoreBundle:Config')
        ;
    }
}
