<?php

namespace Wi\Admin\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
//use Symfony\Component\Validator\Constraints\DateTime;
use Wi\Admin\ContactBundle\Entity\Form;
use Symfony\Component\HttpFoundation\Request;
use Google_Service_Analytics;
use Wi\Admin\CoreBundle\Entity\GoogleAnalyticsReport;


/**
 * Dashboard controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class DashboardController extends Controller
{
    /**
     * Dashboard.
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        // Pobranie wszystkich formularzy kontaktowych.
        $forms = $em->getRepository('WiAdminContactBundle:Form')-> findByFormType(Form::TYPE_CONTACT);

        // Pobranie wszystkich formularzy kontaktowych.
        $leads = $em->getRepository('WiAdminContactBundle:Form')-> findByFormType(Form::TYPE_LEAD);

        // Pobranie danych do Google Api Analytics

        $gaJson = $em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => 'google',
                'name' => 'gaJson',
            ])
            ->getValue();
        $viewId = $em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => 'google',
                'name' => 'gaViewId',
            ])
            ->getValue();

        $googleToken = null;

        $googleAnalytics = $em->getRepository('WiAdminCoreBundle:GoogleAnalyticsReport')->findLast();
        $googleAnalytics = $googleAnalytics[0];
        $today = new \DateTime('NOW');

        // Utworzenie obiektu Google Analytics
        $googleAnalyticsReport = new GoogleAnalyticsReport();
        if(is_null($googleAnalytics) || (! empty($googleAnalytics) && $googleAnalytics->getDateCreated()->format('Y-m-d') != $today->format('Y-m-d')))
        {
            // Logowanie do Google Api.
            if (! is_null($gaJson)){

                // Logowanie do Google Analytics.
                $analytics = $this->initializeAnalytics($gaJson);

                // Pobranie danych z ostatnich 30 dni.
                $report = $this->getReport($analytics, $viewId);
                $visits = $this->getVisits($analytics, $viewId);
                $channelsTable = $this->getChannelsTable($analytics, $viewId);

                $reportTable = $this->printResults($report);
                $visitsTable = $this->printResults($visits);
                $channelsTableTable = $this->printResults($channelsTable);

                $googleAnalyticsReport->setSummaryInfo($reportTable);
                $googleAnalyticsReport->setSummaryChart($visitsTable);
                $googleAnalyticsReport->setChannels($channelsTableTable);

                // Przygotowanie do zapisu.
                $em->persist($googleAnalyticsReport);

                // Zapis.
                $em->flush();

                $googleAnalytics = $googleAnalyticsReport;
            }
        }


        return $this->render('WiAdminCoreBundle:Dashboard:index.html.php', [
            'forms' => $forms,
            'leads' => $leads,
            'googleAnalytics' => $googleAnalytics,
        ]);
    }
    /**
     * Inicjalizacja Google Analytics.
     *
     * @return An authorized Analytics Reporting API V4 service object.
     */
    function initializeAnalytics($gaJson)
    {

        // Use the developers console and download your service account
        // credentials in JSON format. Place them in this directory or
        // change the key file location if necessary.
        $client = new \Google_Client();
        $client->setAuthConfig($this->getParameter('web_dir').'/ga/'.$gaJson);
        $client->addScope(Google_Service_Analytics::ANALYTICS_READONLY);

        $analytics = new \Google_Service_AnalyticsReporting($client);

        return $analytics;
    }

    /**
     * Pobiera dane z Google Analytics
     *
     * @param service An authorized Analytics Reporting API V4 service object.
     * @return The Analytics Reporting API V4 response.
     */
    private function getReport($analytics, $viewID)
    {
        // Replace with your view ID, for example XXXX.
        $VIEW_ID = "$viewID";

        // Create the DateRange object.
        $dateRange = new \Google_Service_AnalyticsReporting_DateRange();
        $dateRange->setStartDate("30daysAgo");
        $dateRange->setEndDate("today");

        // Create the Metrics object.
        // Sesje.
        $sessions = new \Google_Service_AnalyticsReporting_Metric();
        $sessions->setExpression("ga:sessions");
        $sessions->setAlias("sessions");

        // Użytkownicy.
        $users = new \Google_Service_AnalyticsReporting_Metric();
        $users->setExpression("ga:users");
        $users->setAlias("users");

        // Odsłony.
        $visits = new \Google_Service_AnalyticsReporting_Metric();
        $visits->setExpression("ga:pageviews");
        $visits->setAlias("pageviews");

        // Odżucenia.
        $bounceRate = new \Google_Service_AnalyticsReporting_Metric();
        $bounceRate->setExpression("ga:bounceRate");
        $bounceRate->setAlias("bounceRate");

        // Create the ReportRequest object.
        $request = new \Google_Service_AnalyticsReporting_ReportRequest();
        $request->setViewId($VIEW_ID);
        $request->setDateRanges($dateRange);
        $request->setMetrics(array($sessions, $users, $visits, $bounceRate));

        $body = new \Google_Service_AnalyticsReporting_GetReportsRequest();
        $body->setReportRequests( array( $request) );
        return $analytics->reports->batchGet( $body );
    }

    /**
     * Pobiera dane z Google Analytics - wykres wszystkich sesji do sesji z wyszukiwarki google
     *
     * @param service An authorized Analytics Reporting API V4 service object.
     * @return The Analytics Reporting API V4 response.
     */
    private function getVisits($analytics, $viewID)
    {
        // Replace with your view ID, for example XXXX.
        $VIEW_ID = "$viewID";

        // Create the DateRange object.
        $dateRange = new \Google_Service_AnalyticsReporting_DateRange();
        $dateRange->setStartDate("30daysAgo");
        $dateRange->setEndDate("today");

        // Create the Metrics object.
        // Sesje.
        $sessions = new \Google_Service_AnalyticsReporting_Metric();
        $sessions->setExpression("ga:sessions");
        $sessions->setAlias("sessions");

        // Użytkownicy.
        $organicSearches = new \Google_Service_AnalyticsReporting_Metric();
        $organicSearches->setExpression("ga:organicSearches");
        $organicSearches->setAlias("organicSearches");

        $dimensions = new \Google_Service_AnalyticsReporting_Dimension();
        $dimensions->setName("ga:date");

        // Create the ReportRequest object.
        $request = new \Google_Service_AnalyticsReporting_ReportRequest();
        $request->setViewId($VIEW_ID);
        $request->setDateRanges($dateRange);

        $request->setMetrics(array($sessions, $organicSearches));

        $request->setDimensions(array($dimensions));


        $body = new \Google_Service_AnalyticsReporting_GetReportsRequest();
        $body->setReportRequests( array( $request) );
        return $analytics->reports->batchGet( $body );
    }

    /**
     * Pobiera dane z Google Analytics - źródła ruchu na stronie
     *
     * @param service An authorized Analytics Reporting API V4 service object.
     * @return The Analytics Reporting API V4 response.
     */
    private function getChannelsTable($analytics, $viewID)
    {
        // Replace with your view ID, for example XXXX.
        $VIEW_ID = "$viewID";

        // Create the DateRange object.
        $dateRange = new \Google_Service_AnalyticsReporting_DateRange();
        $dateRange->setStartDate("30daysAgo");
        $dateRange->setEndDate("today");

        // Create the Metrics object.
        // Sesje.
        $sessions = new \Google_Service_AnalyticsReporting_Metric();
        $sessions->setExpression("ga:sessions");
        $sessions->setAlias("sessions");
        $percentNewSessions = new \Google_Service_AnalyticsReporting_Metric();
        $percentNewSessions->setExpression("ga:percentNewSessions");
        $percentNewSessions->setAlias("percentNewSessions");
        $newUsers = new \Google_Service_AnalyticsReporting_Metric();
        $newUsers->setExpression("ga:newUsers");
        $newUsers->setAlias("newUsers");
        $bounceRate = new \Google_Service_AnalyticsReporting_Metric();
        $bounceRate->setExpression("ga:bounceRate");
        $bounceRate->setAlias("bounceRate");
        $bounces = new \Google_Service_AnalyticsReporting_Metric();
        $bounces->setExpression("ga:bounces");
        $bounces->setAlias("bounces");
        $goalCompletionsAll = new \Google_Service_AnalyticsReporting_Metric();
        $goalCompletionsAll->setExpression("ga:goalCompletionsAll");
        $goalCompletionsAll->setAlias("goalCompletionsAll");
        $users = new \Google_Service_AnalyticsReporting_Metric();
        $users->setExpression("ga:users");
        $users->setAlias("users");
        $hits = new \Google_Service_AnalyticsReporting_Metric();
        $hits->setExpression("ga:hits");
        $hits->setAlias("hits");
        $events = new \Google_Service_AnalyticsReporting_Metric();
        $events->setExpression("ga:totalEvents");
        $events->setAlias("events");
        $visits = new \Google_Service_AnalyticsReporting_Metric();
        $visits->setExpression("ga:pageviews");
        $visits->setAlias("pageviews");

        $dimensions = new \Google_Service_AnalyticsReporting_Dimension();
        $dimensions->setName("ga:channelGrouping");

        // Create the ReportRequest object.
        $request = new \Google_Service_AnalyticsReporting_ReportRequest();
        $request->setViewId($VIEW_ID);
        $request->setDateRanges($dateRange);

        $request->setMetrics(array($sessions, $percentNewSessions, $newUsers, $bounceRate, $bounces, $goalCompletionsAll, $users, $hits, $events, $visits));

        $request->setDimensions(array($dimensions));


        $body = new \Google_Service_AnalyticsReporting_GetReportsRequest();
        $body->setReportRequests( array( $request) );
        return $analytics->reports->batchGet( $body );
    }

    /**
     * Parsowanie danych pobranych z Google Analytics
     *
     * @param An Analytics Reporting API V4 response.
     */
    private function printResults($reports)
    {
        $table = [];
        for ( $reportIndex = 0; $reportIndex < count( $reports ); $reportIndex++ ) {
            $report = $reports[ $reportIndex ];
            $header = $report->getColumnHeader();
            $dimensionHeaders = $header->getDimensions();
            $metricHeaders = $header->getMetricHeader()->getMetricHeaderEntries();
            $rows = $report->getData()->getRows();

            for ( $rowIndex = 0; $rowIndex < count($rows); $rowIndex++) {
                $row = $rows[ $rowIndex ];
                $dimensions = $row->getDimensions();
                $metrics = $row->getMetrics();
                for ($i = 0; $i < count((array)$dimensionHeaders) && $i < count((array)$dimensions); $i++) {
                    $table[$rowIndex][$dimensionHeaders[$i]] = $dimensions[$i];
                }

                for ($j = 0; $j < count($metrics); $j++) {
                    $values = $metrics[$j]->getValues();
                    for ($k = 0; $k < count($values); $k++) {
                        $entry = $metricHeaders[$k];
                        $table[$rowIndex][$entry->getName()] = $values[$k];
                    }
                }
            }
        }
        return $table;
    }
}

