<?php

namespace Wi\Admin\CoreBundle\Controller;

use Symfony\Component\DependencyInjection\ContainerAwareTrait;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Debug\Exception\FlattenException;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Log\DebugLoggerInterface;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use Wi\Admin\CoreBundle\Utils\StrefaWiCMSAPI;

class ExceptionController implements ContainerAwareInterface
{
    use ContainerAwareTrait;

    public function showAction(Request $request, FlattenException $exception, DebugLoggerInterface $logger = null, $_format = 'html')
    {
        $currentContent = $this->getAndCleanOutputBuffering($request->headers->get('X-Php-Ob-Level', -1));

        $code = $exception->getStatusCode();
        $errorSendId = null;

        // Jeśli konkretny kod błędu to wysłanie informacji o błędzie do strefy.
        if (in_array($code, [500])) {
            $token = $this->container->get('security.token_storage')->getToken();
            $administrator = null;

            if ($token instanceof UsernamePasswordToken && $token->getProviderKey() == 'admin') {
                $administrator = $token->getUser()->getLogin();
            }

            $api = new StrefaWiCMSAPI();
//            $result = $api->errorPost([
//                'publicID' => $this->container->getParameter('public_id'),
//                'type' => $code,
//                'message' => json_encode([
//                    'message' => $exception->getMessage(),
//                    'code' => $exception->getCode(),
//                    'previous' => $exception->getPrevious(),
//                    'trace' => $exception->getTrace(),
//                    'class' => $exception->getClass(),
//                    'statusCode' => $exception->getStatusCode(),
//                    'headers' => $exception->getHeaders(),
//                    'file' => $exception->getFile(),
//                    'line' => $exception->getLine(),
//                ]),
//                'version' => $this->container->getParameter('version'),
//                'administrator' => $administrator,
//            ]);
//
//            $errorSendId = json_decode($result)->id;
        }

        return new Response($this->container->get('templating')->render(
            $this->findTemplate($request, $_format, $code),
            array(
                'status_code'    => $code,
                'status_text'    => isset(Response::$statusTexts[$code]) ? Response::$statusTexts[$code] : '',
                'exception'      => $exception,
                'logger'         => $logger,
                'currentContent' => $currentContent,
                'errorSendId'    => $errorSendId,
            )
        ));
    }

    /**
     * @param int     $startObLevel
     *
     * @return string
     */
    protected function getAndCleanOutputBuffering($startObLevel)
    {
        // ob_get_level() never returns 0 on some Windows configurations, so if
        // the level is the same two times in a row, the loop should be stopped.
        $previousObLevel = null;
        $currentContent = '';

        while (($obLevel = ob_get_level()) > $startObLevel && $obLevel !== $previousObLevel) {
            $previousObLevel = $obLevel;
            $currentContent .= ob_get_clean();
        }

        return $currentContent;
    }

    /**
     * Determine the right template to use for the current Request.
     *
     * @param Request $request
     * @param string $format
     * @param number $code
     * @return string
     */
    protected function findTemplate(Request $request, $format, $code)
    {
        $templating = $this->container->get('templating');
        $token = $this->container->get('security.token_storage')->getToken();

        $prefix = '';
        $engine = 'twig';

        if ($token instanceof UsernamePasswordToken && $token->getProviderKey() == 'admin') {
            $engine = 'php';
            $prefix = 'admin_';
        }

        // $matcher = $this->container->get('ws_exceptions.routing.matcher');

        $names = array(
            $prefix.'error'.$code.'.'.$format.'.'.$engine,
            $prefix.'error.'.$format.'.'.$engine,
            $prefix.'error.html.'.$engine,
        );

        // $prefix = $matcher->match($request);

        // if ($prefix) {
        //     $namesPrefix = array();

        //     foreach ($names as $name) {
        //         $namesPrefix[] = $prefix.'_'.$name;
        //     }

        //     $names = array_merge($namesPrefix, $names);
        // }

        $bundles = array(
            'TwigBundle',
        );

        foreach ($bundles as $bundle) {
            foreach ($names as $name) {
                $template = $bundle.':Exception:'.$name;

                if ($templating->exists($template)) {
                    return $template;
                }
            }
        }

        return 'TwigBundle:Exception:error.html.twig';
    }
}
