<?php

namespace Wi\Admin\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Google_Service_Analytics;

class GoogleAnalyticsController extends Controller
{
    public function indexAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        // Pobranie danych do Google Api Analytics
        $viewId = $em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => 'google',
                'name' => 'gaViewId',
            ])
            ->getValue();

        $gaJson = $em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => 'google',
                'name' => 'gaJson',
            ])
            ->getValue();

        // Utoworzenie obiektu sesji.
        $session = $request->getSession();

        // Logowanie do Google Api
        if (! is_null($gaJson)){
            $client = new \Google_Client();
            $client->setAuthConfig($this->getParameter('web_dir').'/ga/'.$gaJson);
            $client->addScope(Google_Service_Analytics::ANALYTICS_READONLY);

            $googleTokenSession = $session->get('googleToken');
            if($googleTokenSession){
                $client->setAccessToken($googleTokenSession);
            }
            if ($client->isAccessTokenExpired()) {
                $client->fetchAccessTokenWithAssertion();
            }
            $googleToken = $client->getAccessToken();
            $session->set('googleToken', $googleToken);
        } else {
            $googleToken = null;
        }

        return $this->render('WiAdminCoreBundle:GoogleAnalytics:index.html.php', array(
            'gaViewId' => $viewId,
            'gaJson' => $gaJson,
            'googleToken' => $googleToken['access_token'],
        ));
    }

}
