<?php

namespace Wi\Admin\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Wi\Admin\NewsBundle\Entity\News;

class SearchController extends Controller
{
    public function getAutocompleteDataAction(Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        $search = $request->get('search');

        $data = [];

        $news = $em->getRepository('WiAdminNewsBundle:News')->findByTitleWithSerach($search, News::TYPE_NEWS);

        if($news){
            foreach ($news as $item){
                $data[] = [
                    'label' => $item->getTitle(),
                    'category' => 'News',
                    'typ' => 'news',
                    'id' => $item->getId()
                ];
            }
        }

        $blog = $em->getRepository('WiAdminNewsBundle:News')->findByTitleWithSerach($search, News::TYPE_BLOG);

        if($blog){
            foreach ($blog as $item){
                $data[] = [
                    'label' => $item->getTitle(),
                    'category' => 'Blog Post',
                    'typ' => 'blog',
                    'id' => $item->getId()
                ];
            }
        }

        $pages = $em->getRepository('WiAdminPageBundle:Page')->findByTitleWithSerach($search);

        if($pages){
            foreach ($pages as $page){
                $data[] = [
                    'label' => $page->getTitle(),
                    'category' => 'Pages',
                    'typ' => 'page',
                    'id' => $page->getId()
                ];
            }
        }


        return new JsonResponse($data);
    }

    public function indexAction(Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        $search = '';
        if ($request->get('search')){
            $search = $request->get('search');
        }

        $news = null;
        $blog = null;
        $pages = null;


        // Pobranie wszystkich aktywnych aktualności.
        $paginator = $this->get('knp_paginator');
        $news = $paginator->paginate(
            $em->getRepository('WiAdminNewsBundle:News')
                ->getFindAllActiveQuery(
                    News::TYPE_NEWS,
                    null,
                    $search
                ),
            $request->query->getInt('page-news', 1),
            7,
            ['pageParameterName' => 'page-news']
        );

        $blog = $paginator->paginate(
            $em->getRepository('WiAdminNewsBundle:News')
                ->getFindAllActiveQuery(
                    News::TYPE_BLOG,
                    null,
                    $search
                ),
            $request->query->getInt('page-blog', 1),
            7,
            ['pageParameterName' => 'page-blog']
        );
        
        $pages = $paginator->paginate(
            $em->getRepository('WiAdminPageBundle:Page')
                ->getFindAllActiveQuery($search),
            $request->query->getInt('page-page', 1),
            7,
            ['pageParameterName' => 'page-page']
        );

        return $this->render('WiAdminCoreBundle:Search:index.html.php',
            [
                'search' => $search,
                'news' => $news,
                'blog' => $blog,
                'pages' => $pages
            ]
        );
    }

}
