<?php

namespace Wi\Admin\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\CoreBundle\Form\Config\SitemapType;
use Wi\Admin\CoreBundle\Service\Sitemap;

/**
 * Sitemap controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class SitemapController extends Controller
{
    /**
     * Sitemap.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Request $request)
    {
        $form = $this->createForm(SitemapType::class);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();

            foreach ($data as $config => $value) {
                $arr = explode('_', $config);

                if (in_array($arr[1], [
                    'multifile',
                    'splitPagesPerGroup',
                    'splitNewsPerCategory',
                    'splitNewsPerMonth',
                    'splitGalleriesPerAlbum',
                    'includePageImage',
                    'includeNewsImage',
                    'includeGalleryImages',
                    'showImagePublicIndex',
                ])) {
                    $value = intval($value);
                }

                $this->get('config')->save(
                    $arr[0],
                    $arr[1],
                    $value
                );
            }

            return $this->redirectToRoute('wi_admin_core_sitemap_index');
        }

        return $this->render('WiAdminCoreBundle:Sitemap:index.html.php', [
            'form' => $form->createView(),
        ]);
    }

    public function generateAction(Sitemap $sitemap)
    {
        $sitemap->generate();

        return $this->redirectToRoute('wi_admin_core_sitemap_index');
    }
}
