<?php

namespace Wi\Admin\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Wi\Admin\CoreBundle\Entity\Suggestion;
use Wi\Admin\CoreBundle\Utils\StrefaWiCMSAPI;

class SuggestionController extends Controller
{
    /**
     * Widok HTML dla Ajaxa.
     *
     * @param   Request $request
     * @return  Response
     */
    public function indexAction(Request $request)
    {

        $translator = $this->get('translator');

        ob_start();
        include $this->getParameter('kernel.root_dir').'/../src/Wi/Admin/CoreBundle/Resources/views/Suggestion/index.html.php';
        $html = ob_get_clean();

        return new Response($html);
    }

    /**
     * Obsługa formularza ajaxem, wysłanie sugestii.
     *
     * @param   Request $request
     * @return  Response
     */
    public function sendAction(Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        // Utworzenie nowego obiektu Suggestions.
        $suggestion = new Suggestion();

        $translator = $this->get('translator');

        // Obsługa formularzy.
        if ($request->get('content')){
            $suggestion->setContent($request->get('content'));
            $suggestion->setName($request->get('name'));
            $suggestion->setAdmin($this->getUser());
            $suggestion->setUrl($request->get('url'));

            // Przygotowanie do zapisu.
            $em->persist($suggestion);

            // Zapis.
            $em->flush();

            // Wysłanie sugestii do Strefy WiCMS.
            $api = new StrefaWiCMSAPI();
            $params = [
                'publicID' => $this->getParameter('public_id'),       //identyfikator instalacji
                'version' => $this->getParameter('version'),        //numer wersji WiCMS-a,
                'administrator' => $suggestion->getAdmin()->getLogin(),     //login administratora
                'currentUrl' => $suggestion->getUrl(),     //adres, skąd wysłano sugestię
                'message' => $suggestion->getContent(),        //treść sugestii
                'firstName' => $suggestion->getName(),      //imię osoby która wysłała sugestię
            ];
            $sendApi = $api->suggestionPost($params);
        }

        ob_start();
        include $this->getParameter('kernel.root_dir').'/../src/Wi/Admin/CoreBundle/Resources/views/Suggestion/send.html.php';
        $html = ob_get_clean();

        return new Response($html);
    }

    /**
     * Obsługa formularza na stronie błędu 500 ajaxem.
     *
     * @param   Request $request
     * @return  JsonResponse
     */
    public function sendErrorAction(Request $request)
    {

        // Obsługa formularzy.
        if ($request->get('errorInfo')){
            $errorInfo = $request->get('errorInfo');
            $publicId = $this->getParameter('public_id');
            $id = $request->get('id');

            // Wysłanie sugestii do Strefy WiCMS.
            $api = new StrefaWiCMSAPI();
            $params = [
                'comment' => $errorInfo,
                'publicID' => $publicId,
            ];
            $api->errorPut($id, $params);
        }

        return new JsonResponse(true);
    }
}
