<?php

namespace Wi\Admin\CoreBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Parameters Compiler Pass.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ParametersCompilerPass implements CompilerPassInterface
{
    /**
     * Compiler Pass Process.
     *
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $container->get('doctrine.orm.default_entity_manager');

        if ($em->getConnection()->getSchemaManager()->tablesExist(['wicms_config'])) {
            // Pobranie parametrów konfiguracyjnych.
            $parameters = $em->getRepository('WiAdminCoreBundle:Config')->findAll();

            // Ustawienie parametrów.
            foreach ($parameters as $parameter) {
                $container->setParameter($parameter->getGroupName() . '.' . $parameter->getName(), $parameter->getValue());
            }
        }
    }
}
