<?php

namespace Wi\Admin\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * GoogleAnalyticsReport
 *
 * @ORM\Table(name="google_analytics_report")
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Entity(repositoryClass="Wi\Admin\CoreBundle\Repository\GoogleAnalyticsReportRepository")
 */
class GoogleAnalyticsReport
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var array
     *
     * @ORM\Column(name="summaryInfo", type="array")
     */
    private $summaryInfo;

    /**
     * @var array
     *
     * @ORM\Column(name="summaryChart", type="array")
     */
    private $summaryChart;

    /**
     * @var array
     *
     * @ORM\Column(name="channels", type="array")
     */
    private $channels;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    // ------------------------------------------------------------
    // Has Lifecycle Callbacks methods.
    // ------------------------------------------------------------

    /**
     * Funkcja wykonuje się podczas wstawiania nowego rekordu do bazy.
     *
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        // Ustawienie daty utworzenia.
        $this->dateCreated = new \DateTime();
    }

    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Set id
     *
     * @param int $id
     * @return GoogleAnalyticsReport
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }
    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set summaryInfo
     *
     * @param array $summaryInfo
     *
     * @return GoogleAnalyticsReport
     */
    public function setSummaryInfo($summaryInfo)
    {
        $this->summaryInfo = $summaryInfo;

        return $this;
    }

    /**
     * Get summaryInfo
     *
     * @return array
     */
    public function getSummaryInfo()
    {
        return $this->summaryInfo;
    }

    /**
     * Set summaryChart
     *
     * @param array $summaryChart
     *
     * @return GoogleAnalyticsReport
     */
    public function setSummaryChart($summaryChart)
    {
        $this->summaryChart = $summaryChart;

        return $this;
    }

    /**
     * Get summaryChart
     *
     * @return array
     */
    public function getSummaryChart()
    {
        return $this->summaryChart;
    }

    /**
     * Set channels
     *
     * @param array $channels
     *
     * @return GoogleAnalyticsReport
     */
    public function setChannels($channels)
    {
        $this->channels = $channels;

        return $this;
    }

    /**
     * Get channels
     *
     * @return array
     */
    public function getChannels()
    {
        return $this->channels;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return GoogleAnalyticsReport
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
}

