<?php

namespace Wi\Admin\CoreBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Wi\Admin\CoreBundle\Entity\Menu;
use Wi\Admin\CoreBundle\Entity\MenuGroup;

/**
 * Menu
 *
 * @ORM\Table(name="wicms_menu")
 * @ORM\Entity(repositoryClass="Wi\Admin\CoreBundle\Repository\MenuRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class Menu
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var Menu
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\CoreBundle\Entity\MenuGroup")
     * @ORM\JoinColumn(name="group_id", referencedColumnName="id", nullable=true)
     */
    private $group;

    /**
     * @var Menu
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\CoreBundle\Entity\Menu", inversedBy="children")
     * @ORM\JoinColumn(name="parent_id", referencedColumnName="id", nullable=true)
     */
    private $parent;

    /**
     * @var int
     *
     * @ORM\Column(name="orderNr", type="integer", nullable=true)
     */
    private $orderNr;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @var bool
     *
     * @ORM\Column(name="enableLink", type="boolean")
     */
    private $enableLink;

    /**
     * @var string
     *
     * @ORM\Column(name="link", type="string", length=511, nullable=true)
     */
    private $link;

    /**
     * @var string
     *
     * @ORM\Column(name="routeName", type="string", length=255, nullable=true)
     */
    private $routeName;

    /**
     * @var array
     *
     * @ORM\Column(name="routeParams", type="array", nullable=true)
     */
    private $routeParams;

    /**
     * @var string
     *
     * @ORM\Column(name="class", type="string", length=255, nullable=true)
     */
    private $class;

    /**
     * @var bool
     *
     * @ORM\Column(name="advanced", type="boolean")
     */
    private $advanced;

    /**
     * @var array
     *
     * @ORM\Column(name="permission", type="simple_array")
     */
    private $permission;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=1, options={"default": "A", "fixed" = true})
     */
    private $status;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var ArrayCollection
     *
     * @ORM\OneToMany(targetEntity="Wi\Admin\CoreBundle\Entity\Menu", mappedBy="parent")
     * @ORM\OrderBy({"orderNr" = "ASC"})
     */
    private $children;


    // ------------------------------------------------------------
    // Has Lifecycle Callbacks methods.
    // ------------------------------------------------------------

    /**
     * Funkcja wykonuje się podczas wstawiania nowego rekordu do bazy.
     *
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        // Ustawienie daty utworzenia.
        $this->dateCreated = new \DateTime();

        if (is_null($this->status)) {
            $this->status = 'A';
        }
    }

    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Set id
     *
     * @param int $id
     * @return Menu
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set group
     *
     * @param MenuGroup $group
     * @return MenuGroup
     */
    public function setGroup(MenuGroup $group)
    {
        $this->group = $group;

        return $this;
    }

    /**
     * Get group
     *
     * @return MenuGroup
     */
    public function getGroup()
    {
        return $this->group;
    }

    /**
     * Set parent
     *
     * @param Menu $parent
     * @return Menu
     */
    public function setParent(Menu $parent = null)
    {
        $this->parent = $parent;

        return $this;
    }

    /**
     * Get parent
     *
     * @return Menu
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Set orderNr
     *
     * @param integer $orderNr
     * @return Menu
     */
    public function setOrderNr($orderNr)
    {
        $this->orderNr = $orderNr;

        return $this;
    }

    /**
     * Get orderNr
     *
     * @return int
     */
    public function getOrderNr()
    {
        return $this->orderNr;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Menu
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set enableLink
     *
     * @param boolean $enableLink
     * @return Menu
     */
    public function setEnableLink($enableLink)
    {
        $this->enableLink = $enableLink;

        return $this;
    }

    /**
     * Get enableLink
     *
     * @return bool
     */
    public function getEnableLink()
    {
        return $this->enableLink;
    }

    /**
     * Set link
     *
     * @param string $link
     * @return Menu
     */
    public function setLink($link)
    {
        $this->link = $link;

        return $this;
    }

    /**
     * Get link
     *
     * @return string
     */
    public function getLink()
    {
        return $this->link;
    }

    /**
     * Set routeName
     *
     * @param string $routeName
     * @return Menu
     */
    public function setRouteName($routeName)
    {
        $this->routeName = $routeName;

        return $this;
    }

    /**
     * Get routeName
     *
     * @return string
     */
    public function getRouteName()
    {
        return $this->routeName;
    }

    /**
     * Set routeParams
     *
     * @param array $routeParams
     * @return Menu
     */
    public function setRouteParams($routeParams)
    {
        $this->routeParams = $routeParams;

        return $this;
    }

    /**
     * Get routeParams
     *
     * @return array
     */
    public function getRouteParams()
    {
        return $this->routeParams;
    }

    /**
     * Set class
     *
     * @param string $class
     * @return Menu
     */
    public function setClass($class)
    {
        $this->class = $class;

        return $this;
    }

    /**
     * Get class
     *
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }

    /**
     * Set advanced
     *
     * @param boolean $advanced
     * @return Menu
     */
    public function setAdvanced($advanced)
    {
        $this->advanced = $advanced;

        return $this;
    }

    /**
     * Get advanced
     *
     * @return bool
     */
    public function getAdvanced()
    {
        return $this->advanced;
    }

    /**
     * Set permission
     *
     * @param array $permission
     * @return Menu
     */
    public function setPermission($permission)
    {
        $this->permission = $permission;

        return $this;
    }

    /**
     * Get permission
     *
     * @return array
     */
    public function getPermission()
    {
        return $this->permission;
    }

    /**
     * Set status
     *
     * @param string $status
     * @return Menu
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     * @return Menu
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Add child
     *
     * @param Menu $child
     * @return Menu
     */
    public function addChild(Menu $child)
    {
        $this->children[] = $child;

        return $this;
    }

    /**
     * Remove child
     *
     * @param Menu $child
     */
    public function removeChild(Menu $child)
    {
        $this->children->removeElement($child);
    }

    /**
     * Get children
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getChildren()
    {
        return $this->children;
    }

    // ------------------------------------------------------------
    // Methods.
    // ------------------------------------------------------------

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->children = new ArrayCollection();
    }
}
