<?php

namespace Wi\Admin\CoreBundle\Form\Cache;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints as Assert;

class CacheType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Constructor.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $enable = $this->getConfig('cache', 'enable');
        $lifetimePage = $this->getConfig('cache', 'lifetimePage');
        $lifetimeNews = $this->getConfig('cache', 'lifetimeNews');
        $lifetimeNewsList = $this->getConfig('cache', 'lifetimeNewsList');
        $imageEnable = $this->getConfig('cache', 'imageEnable');
        $imageLifetime = $this->getConfig('cache', 'imageLifetime');
        $scriptEnable = $this->getConfig('cache', 'scriptEnable');
        $scriptLifetime = $this->getConfig('cache', 'scriptLifetime');
        $styleEnable = $this->getConfig('cache', 'styleEnable');
        $styleLifetime = $this->getConfig('cache', 'styleLifetime');
        $docEnable = $this->getConfig('cache', 'docEnable');
        $docLifetime = $this->getConfig('cache', 'docLifetime');

        $builder
            ->add('cache_enable', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($enable->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('cache_lifetimePage', IntegerType::class, [
                'attr' => [
                    'class' => 'cache-lifetime ml-0',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $lifetimePage->getValue(),
                'required' => true,
            ])
            ->add('cache_lifetimeNews', IntegerType::class, [
                'attr' => [
                    'class' => 'cache-lifetime ml-0',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $lifetimeNews->getValue(),
                'required' => true,
            ])
            ->add('cache_lifetimeNewsList', IntegerType::class, [
                'attr' => [
                    'class' => 'cache-lifetime ml-0',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $lifetimeNewsList->getValue(),
                'required' => true,
            ])
            ->add('cache_imageEnable', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($imageEnable->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('cache_imageLifetime', IntegerType::class, [
                'attr' => [
                    'class' => 'cache-lifetime ml-0',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $imageLifetime->getValue(),
                'required' => true,
            ])
            ->add('cache_scriptEnable', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($scriptEnable->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('cache_scriptLifetime', IntegerType::class, [
                'attr' => [
                    'class' => 'cache-lifetime ml-0',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $scriptLifetime->getValue(),
                'required' => true,
            ])
            ->add('cache_styleEnable', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($styleEnable->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('cache_styleLifetime', IntegerType::class, [
                'attr' => [
                    'class' => 'cache-lifetime ml-0',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $styleLifetime->getValue(),
                'required' => true,
            ])
            ->add('cache_docEnable', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($docEnable->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('cache_docLifetime', IntegerType::class, [
                'attr' => [
                    'class' => 'cache-lifetime ml-0',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $docLifetime->getValue(),
                'required' => true,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'cache';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera parametr konfiguracji na podstawie przekazanych atrybutów.
     *
     * @param string $groupName
     * @param string $name
     * @return Config
     */
    private function getConfig($groupName, $name)
    {
        return $this->em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => $groupName,
                'name' => $name,
            ])
        ;
    }
}

