<?php

namespace Wi\Admin\CoreBundle\Form\Config;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Config news Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BlogType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Constructor.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $imageWidth = $this->getConfig('blog', 'imageWidth');
        $imageHeight = $this->getConfig('blog', 'imageHeight');
        $thumbnailWidth = $this->getConfig('blog', 'thumbnailWidth');
        $thumbnailHeight = $this->getConfig('blog', 'thumbnailHeight');
        $thumbnailSWidth = $this->getConfig('blog', 'thumbnailSWidth');
        $thumbnailSHeight = $this->getConfig('blog', 'thumbnailSHeight');

        $builder
            ->add('blog_imageWidth', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $imageWidth->getValue(),
                'required' => true,
            ])
            ->add('blog_imageHeight', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $imageHeight->getValue(),
                'required' => true,
            ])
            ->add('blog_thumbnailWidth', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $thumbnailWidth->getValue(),
                'required' => true,
            ])
            ->add('blog_thumbnailHeight', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $thumbnailHeight->getValue(),
                'required' => true,
            ])
            ->add('blog_thumbnailSWidth', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $thumbnailSWidth->getValue(),
                'required' => true,
            ])
            ->add('blog_thumbnailSHeight', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $thumbnailSHeight->getValue(),
                'required' => true,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'config_news_edit';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera parametr konfiguracji na podstawie przekazanych atrybutów.
     *
     * @param string $groupName
     * @param string $name
     * @return Config
     */
    private function getConfig($groupName, $name)
    {
        return $this->em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => $groupName,
                'name' => $name,
            ])
        ;
    }
}
