<?php

namespace Wi\Admin\CoreBundle\Form\Config;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Config news Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ContactType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Constructor.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $apiKey = $this->getConfig('google', 'apiKey');
        $siteKey = $this->getConfig('recaptcha', 'siteKey');
        $secretKey = $this->getConfig('recaptcha', 'secretKey');

        $builder
            ->add('google_apiKey', TextType::class, [
                'attr' => [
                    'class' => '',
                ],
                'constraints' => [],
                'data' => $apiKey->getValue(),
                'required' => false,
            ])
            ->add('recaptcha_siteKey', TextType::class, [
                'attr' => [
                    'class' => '',
                ],
                'constraints' => [],
                'data' => $siteKey->getValue(),
                'required' => false,
            ])
            ->add('recaptcha_secretKey', TextType::class, [
                'attr' => [
                    'class' => '',
                ],
                'constraints' => [],
                'data' => $secretKey->getValue(),
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'config_news_edit';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera parametr konfiguracji na podstawie przekazanych atrybutów.
     *
     * @param string $groupName
     * @param string $name
     * @return Config
     */
    private function getConfig($groupName, $name)
    {
        return $this->em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => $groupName,
                'name' => $name,
            ])
        ;
    }
}
