<?php

namespace Wi\Admin\CoreBundle\Form\Config;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Config news Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class CookieType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Constructor.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $cookieEnable = $this->getConfig('cookie', 'enable');
        $cookieType = $this->getConfig('cookie', 'type');
        $cookieButtonLabel = $this->getConfig('cookie', 'buttonLabel');
        $cookieContent = $this->getConfig('cookie', 'content');
        $cookieSkin = $this->getConfig('cookie', 'skin');

        $builder
            ->add('cookie_enable', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input switchCookieEnable',
                ],
                'required' => false,
                'data' => boolval(intval($cookieEnable->getValue())),
            ])
            ->add('cookie_type', ChoiceType::class, [
                'attr' => [
                    'class' => 'select2cookie',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                ],
                'choices' => [
                    'top_static' => 'top_static',
                    'top_fixed' => 'top_fixed',
                    'bottom_static' => 'bottom_static',
                    'bottom_fixed' => 'bottom_fixed',
                    'corner_static' => 'corner_static',
                    'corner_fixed' => 'corner_fixed',
                    'bottom_right_fixed' => 'bottom_right_fixed',
                    'top_right_fixed' => 'top_right_fixed',
                ],
                //'choice_value' => $cookieType->getValue(),
                //'data' => $cookieType->getValue(),
                'data' => $cookieType->getValue(),
                'required' => true,
            ])
            ->add('cookie_skin', ChoiceType::class, [
                'attr' => [
                    'class' => 'select2cookie',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                ],
                'choices' => [
                    'dark' => 'dark',
                    'light' => 'light',
                ],
                'data' => $cookieSkin->getValue(),
                'required' => true,
            ])
            ->add('cookie_buttonLabel', TextType::class, [
                'attr' => [
                    'class' => 'buttonLabel',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                ],
                'data' => $cookieButtonLabel->getValue(),
                'required' => true,
            ])
            ->add('cookie_content', TextareaType::class, [
                'attr' => [
                    'class' => 'tinyMCEcookieContent',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                ],
                'data' => $cookieContent->getValue(),
                'required' => true,
                'trim' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'config_cookie_edit';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera parametr konfiguracji na podstawie przekazanych atrybutów.
     *
     * @param string $groupName
     * @param string $name
     * @return Config
     */
    private function getConfig($groupName, $name)
    {
        return $this->em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => $groupName,
                'name' => $name,
            ])
        ;
    }
}
