<?php

namespace Wi\Admin\CoreBundle\Form\Config;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Config news Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class GAType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Constructor.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $gaTracking = $this->getConfig('google', 'gaTracking');
        $gaViewId = $this->getConfig('google', 'gaViewId');
        $gaAppId = $this->getConfig('google', 'gaAppId');

        $builder
            ->add('google_gaTracking', TextareaType::class, [
                'attr' => [
                    'class' => 'editor-html',
                ],
                'constraints' => [],
                'data' => $gaTracking->getValue(),
                'required' => false,
            ])
            ->add('google_gaViewId', TextType::class, [
                'attr' => [
                    'class' => '',
                ],
                'constraints' => [],
                'data' => $gaViewId->getValue(),
                'required' => false,
            ])
            ->add('google_gaJson', FileType::class, [
                'attr' => [
                    'accept' => '.json',
                ],
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'config_news_edit';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera parametr konfiguracji na podstawie przekazanych atrybutów.
     *
     * @param string $groupName
     * @param string $name
     * @return Config
     */
    private function getConfig($groupName, $name)
    {
        return $this->em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => $groupName,
                'name' => $name,
            ])
        ;
    }
}
