<?php

namespace Wi\Admin\CoreBundle\Form\Config;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Config metadata Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class MetaDataType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Constructor.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $title = $this->getConfig('metadata', 'title');
        $titleForAllPages = $this->getConfig('metadata', 'titleForAllPages');
        $titleSeparator = $this->getConfig('metadata', 'titleSeparator');
        $description = $this->getConfig('metadata', 'description');
        $keywords = $this->getConfig('metadata', 'keywords');
        $keywordsEnable = $this->getConfig('metadata', 'keywordsEnable');
        $keywordsForAllPages = $this->getConfig('metadata', 'keywordsForAllPages');
        $openGraphEnable = $this->getConfig('metadata', 'openGraphEnable');
        $openGraphDefaultImage = $this->getConfig('metadata', 'openGraphDefaultImage');
        $canonical = $this->getConfig('metadata', 'canonical');
        $canonicalForce = $this->getConfig('metadata', 'canonicalForce');
        $otherHead = $this->getConfig('metadata', 'otherHead');

        $builder
            ->add('metadata_title', TextType::class, [
                'attr' => [
                    'class' => '',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                ],
                'data' => $title->getValue(),
                'required' => true,
            ])
            ->add('metadata_titleForAllPages', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($titleForAllPages->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('metadata_titleSeparator', TextType::class, [
                'attr' => [
                    'class' => '',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                ],
                'data' => $titleSeparator->getValue(),
                'required' => true,
                'trim' => false,
            ])
            ->add('metadata_description', TextType::class, [
                'attr' => [
                    'class' => '',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                ],
                'data' => $description->getValue(),
                'required' => true,
            ])
            ->add('metadata_keywords', TextType::class, [
                'attr' => [
                    'class' => '',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                ],
                'data' => $keywords->getValue(),
                'required' => true,
            ])
            ->add('metadata_keywordsEnable', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($keywordsEnable->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('metadata_keywordsForAllPages', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($keywordsForAllPages->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('metadata_openGraphEnable', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($openGraphEnable->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('metadata_openGraphDefaultImage', TextType::class, [
                'attr' => [
                    'class' => '',
                ],
                'data' => $openGraphDefaultImage->getValue(),
                'required' => false,
            ])
            ->add('metadata_canonical', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($canonical->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('metadata_canonicalForce', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($canonicalForce->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('metadata_otherHead', TextareaType::class, [
                'attr' => [
                    'class' => 'editor-html',
                    'rows' => 15,
                ],
                'data' => $otherHead->getValue(),
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'config_metadata_edit';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera parametr konfiguracji na podstawie przekazanych atrybutów.
     *
     * @param string $groupName
     * @param string $name
     * @return Config
     */
    private function getConfig($groupName, $name)
    {
        return $this->em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => $groupName,
                'name' => $name,
            ])
        ;
    }
}
