<?php

namespace Wi\Admin\CoreBundle\Form\Config;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Config news Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class NewsType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Constructor.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $imageWidth = $this->getConfig('news', 'imageWidth');
        $imageHeight = $this->getConfig('news', 'imageHeight');
        $thumbnailWidth = $this->getConfig('news', 'thumbnailWidth');
        $thumbnailHeight = $this->getConfig('news', 'thumbnailHeight');
        $thumbnailSWidth = $this->getConfig('news', 'thumbnailSWidth');
        $thumbnailSHeight = $this->getConfig('news', 'thumbnailSHeight');

        $builder
            ->add('news_imageWidth', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $imageWidth->getValue(),
                'required' => true,
            ])
            ->add('news_imageHeight', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $imageHeight->getValue(),
                'required' => true,
            ])
            ->add('news_thumbnailWidth', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $thumbnailWidth->getValue(),
                'required' => true,
            ])
            ->add('news_thumbnailHeight', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $thumbnailHeight->getValue(),
                'required' => true,
            ])
            ->add('news_thumbnailSWidth', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $thumbnailSWidth->getValue(),
                'required' => true,
            ])
            ->add('news_thumbnailSHeight', IntegerType::class, [
                'attr' => [
                    'class' => 'news-config-dimensions',
                ],
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\GreaterThan([
                        'value' => 0,
                    ]),
                ],
                'data' => $thumbnailSHeight->getValue(),
                'required' => true,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'config_news_edit';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera parametr konfiguracji na podstawie przekazanych atrybutów.
     *
     * @param string $groupName
     * @param string $name
     * @return Config
     */
    private function getConfig($groupName, $name)
    {
        return $this->em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => $groupName,
                'name' => $name,
            ])
        ;
    }
}
