<?php

namespace Wi\Admin\CoreBundle\Form\Config;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Sitemap Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class SitemapType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Constructor.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $multifile = $this->getConfig('sitemap', 'multifile');
        $splitPagesPerGroup = $this->getConfig('sitemap', 'splitPagesPerGroup');
        $splitNewsPerCategory = $this->getConfig('sitemap', 'splitNewsPerCategory');
        $splitNewsPerMonth = $this->getConfig('sitemap', 'splitNewsPerMonth');
        $splitGalleriesPerAlbum = $this->getConfig('sitemap', 'splitGalleriesPerAlbum');
        $includePageImage = $this->getConfig('sitemap', 'includePageImage');
        $includeNewsImage = $this->getConfig('sitemap', 'includeNewsImage');
        $includeGalleryImages = $this->getConfig('sitemap', 'includeGalleryImages');
        $showImagePublicIndex = $this->getConfig('sitemap', 'showImagePublicIndex');

        $builder
            ->add('sitemap_multifile', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($multifile->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('sitemap_splitPagesPerGroup', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($splitPagesPerGroup->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('sitemap_splitNewsPerCategory', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($splitNewsPerCategory->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('sitemap_splitNewsPerMonth', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($splitNewsPerMonth->getValue())),
                'label' => false,
                'required' => false,
            ])
            /*->add('sitemap_splitGalleriesPerAlbum', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($splitGalleriesPerAlbum->getValue())),
                'label' => false,
                'required' => false,
            ])*/
            ->add('sitemap_includePageImage', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($includePageImage->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('sitemap_includeNewsImage', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($includeNewsImage->getValue())),
                'label' => false,
                'required' => false,
            ])
            /*->add('sitemap_includeGalleryImages', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($includeGalleryImages->getValue())),
                'label' => false,
                'required' => false,
            ])*/
            ->add('sitemap_showImagePublicIndex', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($showImagePublicIndex->getValue())),
                'label' => false,
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'config_sitemap_edit';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera parametr konfiguracji na podstawie przekazanych atrybutów.
     *
     * @param string $groupName
     * @param string $name
     * @return Config
     */
    private function getConfig($groupName, $name)
    {
        return $this->em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => $groupName,
                'name' => $name,
            ])
        ;
    }
}
