<?php

namespace Wi\Admin\CoreBundle\Form\Config;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Wi\Admin\AdminBundle\Entity\Administrator;

/**
 * Config User Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class UserType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Constructor.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $autoAccept = $this->getConfig('user', 'autoAccept');
        $confirmEmail = $this->getConfig('user', 'confirmEmail');
        $notifyAdmin = $this->getConfig('user', 'notifyAdmin');
        $notifyAdminList = $this->getConfig('user', 'notifyAdminList');

        $builder
            ->add('user_autoAccept', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($autoAccept->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('user_confirmEmail', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($confirmEmail->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('user_notifyAdmin', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'data' => boolval(intval($notifyAdmin->getValue())),
                'label' => false,
                'required' => false,
            ])
            ->add('user_notifyAdminList', EntityType::class, [
                'attr' => [
                    'class' => 'chosenSelectCategory',
                ],
                'choice_label' => function ($administrator) {
                    return $administrator->getName();
                },
                'class' => Administrator::class,
                'data' => $this->getData($notifyAdminList->getValue()),
                'multiple' => true,
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'config_user';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Pobiera parametr konfiguracji na podstawie przekazanych atrybutów.
     *
     * @param string $groupName
     * @param string $name
     * @return Config
     */
    private function getConfig($groupName, $name)
    {
        return $this->em->getRepository('WiAdminCoreBundle:Config')
            ->findOneBy([
                'groupName' => $groupName,
                'name' => $name,
            ])
        ;
    }

    private function getData($value)
    {
        return $this->em->getRepository('WiAdminAdminBundle:Administrator')->findBy([
            'id' => explode(',', $value),
        ]);
    }
}

