<?php

namespace Wi\Admin\CoreBundle\Repository;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\EntityRepository;

/**
 * GoogleAnalyticsReportRepository
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class GoogleAnalyticsReportRepository extends EntityRepository
{
    /**
     * Pobiera ostatnio dodany wpis.
     *
     * @return array
     */
    public function findLast()
    {
        return new ArrayCollection(
            $this->createQueryBuilder('r')
            ->orderBy('r.dateCreated', 'DESC')
            ->addOrderBy('r.id', 'DESC')
            ->setMaxResults(1)
            ->getQuery()
            ->getResult()
        );
    }
}
