<?php

namespace Wi\Admin\CoreBundle\Repository;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\EntityRepository;

/**
 * MenuRepository
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class MenuRepository extends EntityRepository
{
    /**
     * Pobiera elementy menu administracyjnego danej grupy, które nie mają
     * żadnego rodzica.
     *
     * @param int $group_id
     * @return ArrayCollection
     */
    public function findAllWithoutParent(int $group_id)
    {
        $result = new ArrayCollection(
            $this->createQueryBuilder('m')
                ->addSelect('c')
                ->leftJoin('m.children', 'c')
                ->innerJoin('m.group', 'g')
                ->where('g.id = :group_id')
                ->orderBy('m.orderNr', 'ASC')
                ->setParameters([
                    'group_id' => $group_id,
                ])
                ->getQuery()
                ->getResult()
        );

        return $result
            ->filter(function ($entry) {
                return is_null($entry->getParent());
            })
        ;
    }
}
