<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_core_config_index')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('configuration.meta.title', [], 'config')); ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/configuration.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li>
    <?php echo $view['translator']->trans('main-menu.administration'); ?>
</li>
<li>
    <?php echo $view['translator']->trans('main-menu.configuration.title'); ?>
</li>
<li><a href="<?php echo $view['router']->path('wi_admin_core_config_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.configuration', [], 'config'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-cogs"></i><?php echo $view['translator']->trans('configuration.title', [], 'config'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
<div class="configuration-tabs">
    <ul class="tabs" data-deep-link="true" data-update-history="true" data-deep-link-smudge="true" data-deep-link-smudge="500" data-tabs id="deeplinked-tabs">
        <li class="tabs-title is-active"><a href="#active" aria-selected="true"><i class="icon-cogs"></i> <?php echo $view['translator']->trans('configuration.tabs.active', [], 'config'); ?></a></li>
        <li class="tabs-title"><a href="#archive" aria-selected="true"><i class="icon-trash"></i> <?php echo $view['translator']->trans('configuration.tabs.archive', [], 'config'); ?></a></li>
    </ul>

    <div class="tabs-content" data-tabs-content="deeplinked-tabs">
        <div class="tabs-panel is-active" id="active">
            <?php echo $view->render('WiAdminCoreBundle:Config:Components/active.html.php', [
                'configuration' => $configuration,
                'form' => $form,
            ]); ?>
        </div>
        <div class="tabs-panel" id="archive">
            <?php echo $view->render('WiAdminCoreBundle:Config:Components/archive.html.php', [
                'configurationArchive' => $configurationArchive,
            ]); ?>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/configuration.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
