<?php $view->extend('::wicms.html.php') ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_news_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.dashboard')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/webimpuls-normalize.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/ga.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/dashboard.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
<li>
    <a href="<?php echo $view['router']->path('wi_admin_admin_dashboard'); ?>"><?php echo $view['translator']->trans('breadcrumbs.dashboard'); ?></a>
</li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
<i class="icon-desktop"></i><?php echo $view['translator']->trans('dashboard.Title'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
<?php $stats = $view['front']->getStats(); ?>
<div class="row">
    <div class="columns small-12 medium-6">
        <div class="box palette-Blue-500 bg">
            <div class="box-header  palette-Blue-500 bg">
                <!-- tools box -->
                <div class="pull-right text-white box-tools">
                    <?php if ($view['security']->isGranted('ROLE_CONTACT_INDEX')): ?>
                        <span class="text-white box-btn">
                            <a href="<?php echo $view['router']->path('wi_admin_contact_leads') ?>" title="<?php echo $view['translator']->trans('dashboard.ShowMessages'); ?>" class="tooltipster-top tooltipstered">
                                <i class="text-white circle-nest icon-comment "></i>
                            </a>
                        </span>
                    <?php endif; ?>
                    <?php if ($view['security']->isGranted('ROLE_CONTACT_INDEX')): ?>
                        <span class="configDash">
                            <a data-toggle="configLead">
                                <i class="text-white icon-dot-3"></i>
                            </a>
                        </span>
                        <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configLead" data-dropdown data-close-on-click="true">
                            <ul class="no-bullet">
                                <?php if ($view['security']->isGranted('ROLE_CONTACT_EDIT')): ?>
                                    <li>
                                        <a href="<?php echo $view['router']->path('wi_admin_contact_new') ?>" title="<?php echo $view['translator']->trans('dashboard.newForm'); ?>" class="">
                                            <span>
                                                <i class="icon-list-add"></i>
                                                <?php echo $view['translator']->trans('dashboard.newForm'); ?>
                                            </span>

                                        </a>
                                    </li>
                                <?php endif; ?>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_contact_index') ?>" title="<?php echo $view['translator']->trans('dashboard.ShowContact'); ?>" class="">
                                        <span>
                                            <i class="icon-edit-1"></i>
                                            <?php echo $view['translator']->trans('dashboard.ShowContact'); ?>
                                        </span>

                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_contact_leads') ?>" title="<?php echo $view['translator']->trans('dashboard.ShowMessages'); ?>" class="">
                                        <span>
                                            <i class="icon-comment "></i>
                                            <?php echo $view['translator']->trans('dashboard.ShowMessages'); ?>
                                        </span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
                <h3 class="box-title"><i class="text-white circle-nest-medium icon-bell-1"></i>
                    <span class="text-white"><?php echo $view['translator']->trans('dashboard.leadForm'); ?></span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="row">
                <div class="events-nest">
                    <div class="wrap-no-pad text-white <?php echo $stats['formCountLeadNewAnswer'] > 0 ? 'accordionLead' : ''; ?>">
                        <h1 class="text-white counter-up-fast countDashboard">
                            <?php echo $stats['formCountLeadNewAnswer']; ?>
                        </h1>
                        <span>
                            <?php if($stats['formCountLeadNewAnswer'] == 0): ?>
                                <?php echo $view['translator']->trans('dashboard.formNewAnswerLead0'); ?>
                            <?php elseif ($stats['formCountLeadNewAnswer'] == 1): ?>
                                <?php echo $view['translator']->trans('dashboard.formNewAnswerLead1'); ?>
                                <i class="icon-down-open-1 iconLeadDown"></i><i class="icon-up-open-1 iconLeadUp hide"></i>
                            <?php elseif ($stats['formCountLeadNewAnswer'] > 1 && $stats['formCountContactNewAnswer'] < 6): ?>
                                <?php echo $view['translator']->trans('dashboard.formNewAnswerLead2'); ?>
                                <i class="icon-down-open-1 iconLeadDown"></i><i class="icon-up-open-1 iconLeadUp hide"></i>
                            <?php elseif ($stats['formCountLeadNewAnswer'] == 0): ?>
                                <?php echo $view['translator']->trans('dashboard.formNewAnswerLead'); ?>
                                <i class="icon-down-open-1 iconLeadDown"></i><i class="icon-up-open-1 iconLeadUp hide"></i>
                            <?php endif; ?>
                        </span>
                        <p>
                            <?php echo $stats['formCountLeadAnswer']; ?> <?php echo $view['translator']->trans('dashboard.formAnswerLead'); ?>
                        </p>
                    </div>
                </div>
            </div>
            <?php if ($leads && count($leads) > 0 && $stats['formCountLeadNewAnswer'] > 0): ?>
                <div class="row">
                    <ul class="accordion accordionLeads" data-accordion data-allow-all-closed="true">
                        <li class="accordion-item" data-accordion-item>
                            <div class="accordion-content accordionLeadContent" data-tab-content>
                                <ul>
                                    <?php foreach ($leads as $key => $form): ?>
                                        <li class="formsItem formItem lastNewsItem">
                                            <h4>
                                            <span>
                                                <?php if ($view['security']->isGranted('ROLE_CONTACT_INDEX')): ?>
                                                    <a href="<?php echo $view['router']->path('wi_admin_contact_index_form', ['id' => $form->getId()]); ?>">
                                                        <?php echo $view['translator']->trans('dashboard.form'); ?> "<?php echo $form->getName(); ?>"
                                                    </a>
                                                <?php else: ?>
                                                    <?php echo $view['translator']->trans('dashboard.form'); ?> "<?php echo $form->getName(); ?>"
                                                <?php endif; ?>
                                            </span>
                                                <small class="float-right">
                                                    <?php echo $view['translator']->trans('dashboard.allAnswer'); ?>: <?php echo $stats['formCountGroup'][$form->getId()]; ?>
                                                </small>
                                                <small class="float-right smallInfo2">
                                                    <?php echo $view['translator']->trans('dashboard.allNewAnswer'); ?>: <?php echo $stats['formCountUnreadedGroup'][$form->getId()]; ?>
                                                </small>
                                            </h4>
                                            <div class="buttonItemsBox">
                                                <div class="buttonsItems">
                                                    <?php if ($view['security']->isGranted('ROLE_CONTACT_INDEX')): ?>
                                                        <a href="<?php echo $form->getType() == 'C' ?  $view['router']->path('wi_admin_contact_messages', ['id' => $form->getId()]) : $view['router']->path('wi_admin_contact_leads_form', ['id' => $form->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('dashboard.showAnswer'); ?></a> /
                                                    <?php endif; ?>
                                                    <?php if ($view['security']->isGranted('ROLE_CONTACT_INDEX')): ?>
                                                        <a href="<?php echo $view['router']->path('wi_admin_contact_index_form', ['id' => $form->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('dashboard.menageForm'); ?></a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <hr>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </li>
                        <!-- ... -->
                    </ul>
                </div>
            <?php endif; ?>
            <!-- /.box-body -->
        </div>
    </div>
    <div class="columns small-12 medium-6">
        <div class="box palette-Cyan-400 bg">
            <div class="box-header  palette-Cyan-400 bg">
                <!-- tools box -->
                <div class="pull-right text-white box-tools">
                    <?php if ($view['security']->isGranted('ROLE_CONTACT_INDEX')): ?>
                        <span class="text-white box-btn">
                            <a href="<?php echo $view['router']->path('wi_admin_contact_messages_all') ?>" title="<?php echo $view['translator']->trans('dashboard.ShowMessages'); ?>" class="tooltipster-top tooltipstered">
                                <i class="text-white circle-nest icon-post"></i>
                            </a>
                        </span>
                    <?php endif; ?>
                    <?php if ($view['security']->isGranted('ROLE_CONTACT_INDEX')): ?>
                        <span class="configDash">
                            <a data-toggle="configMess">
                                <i class="text-white icon-dot-3"></i>
                            </a>
                        </span>
                        <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configMess" data-dropdown data-close-on-click="true">
                            <ul class="no-bullet">
                                <?php if ($view['security']->isGranted('ROLE_CONTACT_EDIT')): ?>
                                    <li>
                                        <a href="<?php echo $view['router']->path('wi_admin_contact_new') ?>" title="<?php echo $view['translator']->trans('dashboard.newForm'); ?>" class="">
                                            <span>
                                                <i class="icon-list-add"></i>
                                                <?php echo $view['translator']->trans('dashboard.newForm'); ?>
                                            </span>

                                        </a>
                                    </li>
                                <?php endif; ?>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_contact_index') ?>" title="<?php echo $view['translator']->trans('dashboard.ShowContact'); ?>" class="">
                                        <span>
                                            <i class="icon-edit-1"></i>
                                            <?php echo $view['translator']->trans('dashboard.ShowContact'); ?>
                                        </span>

                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_contact_messages_all') ?>" title="<?php echo $view['translator']->trans('dashboard.ShowMessages'); ?>" class="">
                                        <span>
                                            <i class="icon-comment "></i>
                                            <?php echo $view['translator']->trans('dashboard.ShowMessages'); ?>
                                        </span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
                <h3 class="box-title"><i class="text-white circle-nest-medium icon-post"></i>
                    <span class="text-white"><?php echo $view['translator']->trans('dashboard.contactForm'); ?></span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="row">
                <div class="events-nest">
                    <div class="wrap-no-pad text-white <?php echo $stats['formCountContactNewAnswer'] > 0 ? 'accordionMessages' : ''; ?>">
                        <h1 class="text-white counter-up-fast countDashboard">
                            <?php echo $stats['formCountContactNewAnswer']; ?>
                        </h1>
                        <span>
                            <?php if($stats['formCountContactNewAnswer'] == 0): ?>
                                <?php echo $view['translator']->trans('dashboard.formNewAnswerContact0'); ?>
                            <?php elseif ($stats['formCountContactNewAnswer'] == 1): ?>
                                <?php echo $view['translator']->trans('dashboard.formNewAnswerContact1'); ?>
                                <i class="icon-down-open-1 iconMessagesDown"></i><i class="icon-up-open-1 iconMessagesUp hide"></i>
                            <?php elseif ($stats['formCountContactNewAnswer'] > 1 && $stats['formCountContactNewAnswer'] < 6): ?>
                                <?php echo $view['translator']->trans('dashboard.formNewAnswerContact2'); ?>
                                <i class="icon-down-open-1 iconMessagesDown"></i><i class="icon-up-open-1 iconMessagesUp hide"></i>
                            <?php else: ?>
                                <?php echo $view['translator']->trans('dashboard.formNewAnswerContact'); ?>
                                <i class="icon-down-open-1 iconMessagesDown"></i><i class="icon-up-open-1 iconMessagesUp hide"></i>
                            <?php endif; ?>
                        </span>
                        <p>
                            <?php echo $stats['formCountContactAnswer']; ?> <?php echo $view['translator']->trans('dashboard.formAnswerContact'); ?>
                        </p>
                    </div>
                </div>
            </div>
            <?php if($forms && count($forms) > 0 && $stats['formCountContactNewAnswer'] > 0): ?>
                <div class="row">
                    <ul class="accordion accordionMess" data-accordion data-allow-all-closed="true">
                        <li class="accordion-item" data-accordion-item>
                            <div class="accordion-content accordionMessagesContent" data-tab-content>
                                <ul>
                                    <?php foreach ($forms as $key => $form): ?>
                                        <?php if ($stats['formCountUnreadedGroup'][$form->getId()] > 0): ?>
                                            <li class="formsItem formItem lastNewsItem">
                                                <h4>
                                                <span>
                                                    <?php if ($view['security']->isGranted('ROLE_CONTACT_INDEX')): ?>
                                                        <a href="<?php echo $view['router']->path('wi_admin_contact_index_form', ['id' => $form->getId()]); ?>">
                                                            <?php echo $view['translator']->trans('dashboard.form'); ?> "<?php echo $form->getName(); ?>"
                                                        </a>
                                                    <?php else: ?>
                                                        <?php echo $view['translator']->trans('dashboard.form'); ?> "<?php echo $form->getName(); ?>"
                                                    <?php endif; ?>
                                                </span>
                                                    <small class="float-right">
                                                        <?php echo $view['translator']->trans('dashboard.allAnswer'); ?>: <?php echo $stats['formCountGroup'][$form->getId()]; ?>
                                                    </small>
                                                    <small class="float-right smallInfo2">
                                                        <?php echo $view['translator']->trans('dashboard.allNewAnswer'); ?>: <?php echo $stats['formCountUnreadedGroup'][$form->getId()]; ?>
                                                    </small>
                                                </h4>
                                                <div class="buttonItemsBox">
                                                    <div class="buttonsItems">
                                                        <?php if ($view['security']->isGranted('ROLE_CONTACT_INDEX')): ?>
                                                            <a href="<?php echo $form->getType() == 'C' ?  $view['router']->path('wi_admin_contact_messages', ['id' => $form->getId()]) : $view['router']->path('wi_admin_contact_leads_form', ['id' => $form->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('dashboard.showAnswer'); ?></a> /
                                                        <?php endif; ?>
                                                        <?php if ($view['security']->isGranted('ROLE_CONTACT_INDEX')): ?>
                                                            <a href="<?php echo $view['router']->path('wi_admin_contact_index_form', ['id' => $form->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('dashboard.menageForm'); ?></a>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <hr>
                                            </li>
                                    <?php endif; ?>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </li>
                        <!-- ... -->
                    </ul>
                </div>
            <?php endif; ?>
            <!-- /.box-body -->
        </div>
    </div>
</div>
<div class="row">
    <div class="columns small-12 medium-6 large-3">
        <div class="box palette-Lime-700 bg">
            <div class="box-header  palette-Lime-700 bg">
                <!-- tools box -->
                <div class="pull-right text-white box-tools">
                    <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                        <span class="text-white box-btn">
                            <a href="<?php echo $view['router']->path('wi_admin_pages_new') ?>" title="<?php echo $view['translator']->trans('pagesList.add'); ?>" class="tooltipster-top tooltipstered">
                                <i class="text-white circle-nest icon-doc-new"></i>
                            </a>
                        </span>
                    <?php endif; ?>
                    <?php if ($view['security']->isGranted('ROLE_PAGES_INDEX')): ?>
                        <span class="configDash">
                            <a data-toggle="configPages">
                                <i class="text-white icon-dot-3"></i>
                            </a>
                        </span>
                        <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configPages" data-dropdown data-close-on-click="true">
                            <ul class="no-bullet">
                                <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                                    <li>
                                        <a href="<?php echo $view['router']->path('wi_admin_pages_new') ?>" title="<?php echo $view['translator']->trans('pagesList.add'); ?>" class="">
                                            <span>
                                                <i class="icon-doc-new"></i>
                                                <?php echo $view['translator']->trans('pagesList.add'); ?>
                                            </span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <li>
                                    <?php if ($view['security']->isGranted('ROLE_PAGES_INDEX')): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>" title="<?php echo $view['translator']->trans('dashboard.ShowAllPages'); ?>">
                                            <span><i class="icon-edit-1"></i><?php echo $view['translator']->trans('dashboard.ShowAllPages'); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </li>
                                <li>
                                    <?php if ($view['security']->isGranted('ROLE_PAGES_INDEX')): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_page_groups_index'); ?>" title="<?php echo $view['translator']->trans('dashboard.editGroupPages'); ?>">
                                            <span><i class="icon-folder-2"></i><?php echo $view['translator']->trans('dashboard.editGroupPages'); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </li>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
                <h3 class="box-title"><i class="text-white circle-nest-medium icon-doc-text-1"></i>
                    <span class="text-white">
                        <?php echo $view['translator']->trans('dashboard.lastPages'); ?>
                    </span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="row">
                <div class="events-nest">
                    <div class="wrap-no-pad text-white">
                        <a href="<?php echo $view['security']->isGranted('ROLE_PAGES_INDEX') ? $view['router']->path('wi_admin_pages_index') : ''; ?>">
                            <h1 class="text-white counter-up-fast countDashboard">
                                <?php echo $stats['pagesCount']; ?>
                            </h1>
                            <span>
                            <?php if ($stats['pagesCount']==1): ?>
                                <?php echo $view['translator']->trans('dashboard.countPages1'); ?>
                            <?php elseif ($stats['pagesCount']>1 && $stats['pagesCount']<4): ?>
                                <?php echo $view['translator']->trans('dashboard.countPages2'); ?>
                            <?php else: ?>
                                <?php echo $view['translator']->trans('dashboard.countPages'); ?>
                            <?php endif; ?>
                        </span>
                        </a>

                        <p>
                            <?php echo $view['translator']->trans('dashboard.in'); ?> <?php echo $stats['groupCount']; ?> <?php echo $view['translator']->trans('dashboard.countGroup'); ?>
                        </p>
                    </div>
                </div>
            </div>
            <!-- /.box-body -->
        </div>
    </div>
    <div class="columns small-12 medium-6 large-3">
        <div class="box palette-Yellow-600 bg">
            <div class="box-header  palette-Yellow-600 bg">
                <!-- tools box -->
                <div class="pull-right text-white box-tools">
                    <?php if ($view['security']->isGranted('ROLE_NEWS_EDIT')): ?>
                        <span class="text-white box-btn">
                            <a href="<?php echo $view['router']->path('wi_admin_news_new') ?>" title="<?php echo $view['translator']->trans('newsList.add'); ?>" class="tooltipster-top tooltipstered">
                                <i class="text-white circle-nest icon-doc-new"></i>
                            </a>
                        </span>
                    <?php endif; ?>
                    <?php if ($view['security']->isGranted('ROLE_NEWS_INDEX')): ?>
                        <span class="configDash">
                            <a data-toggle="configNews">
                                <i class="text-white icon-dot-3"></i>
                            </a>
                        </span>
                        <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configNews" data-dropdown data-close-on-click="true">
                            <ul class="no-bullet">
                                <li>
                                    <?php if ($view['security']->isGranted('ROLE_NEWS_EDIT')): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_news_new') ?>" title="<?php echo $view['translator']->trans('newsList.add'); ?>" class="">
                                            <span>
                                                <i class="icon-doc-new"></i>
                                                <?php echo $view['translator']->trans('newsList.add'); ?>
                                            </span>
                                        </a>
                                    <?php endif; ?>
                                </li>
                                <li>
                                    <?php if ($view['security']->isGranted('ROLE_NEWS_INDEX')): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_news_index'); ?>" title="<?php echo $view['translator']->trans('dashboard.ShowAllNews'); ?>">
                                            <span><i class="icon-edit-1"></i><?php echo $view['translator']->trans('dashboard.ShowAllNews'); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </li>
                                <li>
                                    <?php if ($view['security']->isGranted('ROLE_NEWS_INDEX')): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_news_categories_index'); ?>" title="<?php echo $view['translator']->trans('dashboard.editNewsCategory'); ?>">
                                            <span><i class="icon-folder-2"></i><?php echo $view['translator']->trans('dashboard.editNewsCategory'); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </li>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
                <h3 class="box-title"><i class="text-white circle-nest-medium icon-doc-text-1"></i>
                    <span class="text-white"><?php echo $view['translator']->trans('dashboard.lastNews'); ?></span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="row">
                <div class="events-nest">
                    <div class="wrap-no-pad text-white">
                        <a href="<?php echo $view['security']->isGranted('ROLE_NEWS_INDEX') ? $view['router']->path('wi_admin_news_index') : ''; ?>">
                            <h1 class="text-white counter-up-fast countDashboard">
                                <?php echo $stats['newsCount']; ?>
                            </h1>
                            <span>
                            <?php if ($stats['newsCount']==1): ?>
                                <?php echo $view['translator']->trans('dashboard.countNews1'); ?>
                            <?php else: ?>
                                <?php echo $view['translator']->trans('dashboard.countNews'); ?>
                            <?php endif; ?>
                        </span>
                        </a>
                        <p>
                            <?php echo $view['translator']->trans('dashboard.in'); ?> <?php echo $stats['categoryCount']; ?> <?php echo $view['translator']->trans('dashboard.countCategory'); ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="columns small-12 medium-6 large-3">
        <div class="box palette-Yellow-800 bg">
            <div class="box-header  palette-Yellow-800 bg">
                <!-- tools box -->
                <div class="pull-right text-white box-tools">
                    <?php if ($view['security']->isGranted('ROLE_BLOG_EDIT')): ?>
                        <span class="text-white box-btn">
                            <a href="<?php echo $view['router']->path('wi_admin_blog_new') ?>" title="<?php echo $view['translator']->trans('blogList.add'); ?>" class="tooltipster-top tooltipstered">
                                <i class="text-white circle-nest icon-doc-new"></i>
                            </a>
                        </span>
                    <?php endif; ?>
                    <?php if ($view['security']->isGranted('ROLE_BLOG_INDEX')): ?>
                        <span class="configDash">
                            <a data-toggle="configBlog">
                                <i class="text-white icon-dot-3"></i>
                            </a>
                        </span>
                        <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configBlog" data-dropdown data-close-on-click="true">
                            <ul class="no-bullet">
                                <?php if ($view['security']->isGranted('ROLE_BLOG_EDIT')): ?>
                                    <li>
                                        <a href="<?php echo $view['router']->path('wi_admin_blog_new') ?>" title="<?php echo $view['translator']->trans('blogList.add'); ?>" class="">
                                            <span>
                                                <i class="icon-doc-new"></i>
                                                <?php echo $view['translator']->trans('blogList.add'); ?>
                                            </span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <li>
                                    <?php if ($view['security']->isGranted('ROLE_BLOG_INDEX')): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_blog_index'); ?>" title="<?php echo $view['translator']->trans('dashboard.ShowAllPost'); ?>">
                                            <span><i class="icon-edit-1"></i><?php echo $view['translator']->trans('dashboard.ShowAllPost'); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </li>
                                <li>
                                    <?php if ($view['security']->isGranted('ROLE_BLOG_INDEX')): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_blog_categories_index'); ?>" title="<?php echo $view['translator']->trans('dashboard.editBlogCategory'); ?>">
                                            <span><i class="icon-folder-2"></i><?php echo $view['translator']->trans('dashboard.editBlogCategory'); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </li>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
                <h3 class="box-title"><i class="text-white circle-nest-medium icon-doc"></i>
                    <span class="text-white"><?php echo $view['translator']->trans('dashboard.lastBlog'); ?></span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="row">
                <div class="events-nest">
                    <div class="wrap-no-pad text-white">
                        <a href="<?php echo $view['security']->isGranted('ROLE_BLOG_INDEX') ? $view['router']->path('wi_admin_blog_index') : ''; ?>">
                            <h1 class="text-white counter-up-fast countDashboard">
                                <?php echo $stats['blogCount']; ?>
                            </h1>
                            <span>
                                <?php if ($stats['blogCount']==1): ?>
                                    <?php echo $view['translator']->trans('dashboard.countBlog1'); ?>
                                <?php elseif ($stats['blogCount']>1 && $stats['blogCount']<4): ?>
                                    <?php echo $view['translator']->trans('dashboard.countBlog2'); ?>
                                <?php else: ?>
                                    <?php echo $view['translator']->trans('dashboard.countBlog'); ?>
                                <?php endif; ?>
                            </span>
                        </a>
                        <p>
                            <?php echo $view['translator']->trans('dashboard.in'); ?> <?php echo $stats['categoryBlogCount']; ?> <?php echo $view['translator']->trans('dashboard.countCategoryPost'); ?>
                        </p>
                    </div>
                </div>
            </div>
            <!-- /.box-body -->
        </div>
    </div>
    <div class="columns small-12 medium-6 large-3">
        <div class="box palette-Teal-300 bg">
            <div class="box-header  palette-Teal-300 bg">
                <!-- tools box -->
                <div class="pull-right text-white box-tools">
                    <?php if ($view['security']->isGranted('ROLE_NEWS_INDEX')): ?>
                        <span class="configDash">
                            <a data-toggle="configComments">
                                <i class="text-white icon-dot-3"></i>
                            </a>
                        </span>
                        <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configComments" data-dropdown data-close-on-click="true">
                            <ul class="no-bullet">
                                <li>
                                    <?php if ($view['security']->isGranted('ROLE_NEWS_INDEX')): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_news_comment_index'); ?>" title="<?php echo $view['translator']->trans('dashboard.editComment'); ?>">
                                            <span><i class="icon-comment"></i><?php echo $view['translator']->trans('dashboard.editComment'); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </li>
                                <li>
                                    <?php if ($view['security']->isGranted('ROLE_CONFIGURATION_INDEX')): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_core_config_comment'); ?>" title="<?php echo $view['translator']->trans('dashboard.configComment'); ?>">
                                            <span><i class="icon-cog-5"></i><?php echo $view['translator']->trans('dashboard.configComment'); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </li>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
                <h3 class="box-title"><i class="text-white circle-nest-medium icon-comment"></i>
                    <span class="text-white"><?php echo $view['translator']->trans('dashboard.comment'); ?></span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="row">
                <div class="events-nest">
                    <div class="wrap-no-pad text-white">
                        <a href="<?php echo $view['security']->isGranted('ROLE_NEWS_INDEX') ? $view['router']->path('wi_admin_news_comment_index') : ''; ?>">
                            <h1 class="text-white counter-up-fast countDashboard">
                                <?php echo $stats['commentCount']; ?>
                            </h1>
                            <span>
                                <?php if ($stats['commentCount']==1): ?>
                                    <?php echo $view['translator']->trans('dashboard.countComment1'); ?>
                                <?php elseif ($stats['commentCount']>1 && $stats['commentCount']<4): ?>
                                    <?php echo $view['translator']->trans('dashboard.countComment2'); ?>
                                <?php else: ?>
                                    <?php echo $view['translator']->trans('dashboard.countComment'); ?>
                                <?php endif; ?>
                            </span>
                        </a>
                        <p>
                            <?php echo $view['translator']->trans('dashboard.in'); ?> <?php echo $stats['commentNewsCount']; ?> <?php echo $view['translator']->trans('dashboard.commentPost'); ?>
                        </p>
                    </div>
                </div>
            </div>
            <!-- /.box-body -->
        </div>
    </div>
</div>
<?php if($googleAnalytics): ?>
    <?php $summaryInfo = $googleAnalytics->getSummaryInfo(); ?>
    <?php $summaryChart = $googleAnalytics->getSummaryChart(); ?>
    <?php $channels = $googleAnalytics->getChannels(); ?>
    <hr class="hrGA">
    <h1 class="titleSite titleGA">
        <i class="icon-chart-bar"></i><?php echo $view['translator']->trans('dashboard.gaTitle'); ?>
    </h1>
    <div class="row">
        <div class="columns">
            <div class="box analyticsStatsBox">
                <div class="box-body " style="display: block;">
                        <section id="raportGA">
                            <div class="row subTytul subtytulDash">
                                <div class="columns large-12 text-left">
                                    <h2 style="margin-top:0px;"><i class="icon-users"></i>
                                        <span>
                                <?php echo $view['translator']->trans('dashboard.gaUsersTitle'); ?>
                            </span>
                                    </h2>
                                </div>
                            </div>
                            <div class="row">
                                <div class="columns large-3 medium-6 small-12">
                                    <div class="panel white sessions-liczba ikonaLiczba" title="
                                    <?php echo $view['translator']->trans('configuration.ga.report.sessionDesc', [], 'analytics'); ?>">
                                        <div class="row">
                                            <div class="columns large-5 medium-6 small-6 ikona">
                                                <i class="icon-desktop"></i>
                                            </div>
                                            <div class="columns large-7 medium-6 small-6 liczba end">
                                                <h3>
                                                    <?php echo $view['translator']->trans('configuration.ga.report.session', [], 'analytics'); ?>:
                                                </h3>
                                                <div id="sessions-liczba">
                                                    <div class="pleasWait">
                                                        <h2 class=""><?php echo number_format($summaryInfo[0]['sessions'], 0, ', ', ' '); ?></h2>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="columns large-3 medium-6 small-12">
                                    <div class="panel white users-liczba ikonaLiczba"  title="<?php echo $view['translator']->trans('configuration.ga.report.userDesc', [], 'analytics'); ?>">
                                        <div class="row">
                                            <div class="columns large-5 medium-6 small-6 ikona">
                                                <i class="icon-users"></i>
                                            </div>
                                            <div class="columns large-7 medium-6 small-6 liczba end">
                                                <h3><?php echo $view['translator']->trans('configuration.ga.report.users', [], 'analytics'); ?>:</h3>
                                                <div id="users-liczba">
                                                    <h2 class="">
                                                        <?php echo number_format($summaryInfo[0]['users'], 0, ', ', ' '); ?>
                                                    </h2>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="columns large-3 medium-6 small-12">
                                    <div class="panel white pageviews-liczba ikonaLiczba" title="<?php echo $view['translator']->trans('configuration.ga.report.viewsDesc', [], 'analytics'); ?>">
                                        <div class="row">
                                            <div class="columns large-5 medium-6 small-6 ikona">
                                                <i class="icon-doc"></i>
                                            </div>
                                            <div class="columns large-7 medium-6 small-6 liczba end">
                                                <h3><?php echo $view['translator']->trans('configuration.ga.report.views', [], 'analytics'); ?></h3>
                                                <div id="pageviews-liczba">
                                                    <h2 class="">
                                                        <?php echo number_format($summaryInfo[0]['pageviews'], 0, ', ', ' '); ?>
                                                    </h2>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="columns large-3 medium-6 small-12">
                                    <div class="panel white bounceRate-liczba ikonaLiczba"  title="<?php echo $view['translator']->trans('configuration.ga.report.bounceDesc', [], 'analytics'); ?>">
                                        <div class="row">
                                            <div class="columns large-5 medium-6 small-6 ikona">
                                                <i class="icon-user-times"></i>
                                            </div>
                                            <div class="columns large-7 medium-6 small-6 liczba end">
                                                <h3><?php echo $view['translator']->trans('configuration.ga.report.bounce', [], 'analytics'); ?>:</h3>
                                                <div id="bounceRate-liczba">
                                                    <h2 class="">
                                                        <?php echo number_format($summaryInfo[0]['bounceRate'], 2, ', ', ' '); ?>%
                                                    </h2>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="columns large-12 text-center">
                                    <div class="panel white sessions-wykres">
                                        <div class="panelHeader">
                                            <h3><?php echo $view['translator']->trans('configuration.ga.report.visitsSession', [], 'analytics'); ?></h3>
                                            <h4><?php echo $view['translator']->trans('configuration.ga.report.visitsSessionDesc', [], 'analytics'); ?></h4>
                                        </div>
                                        <script>
                                            var tableSessions = [
                                                ["<?php echo $view['translator']->trans('dashboard.data'); ?>", "<?php echo $view['translator']->trans('dashboard.sessions'); ?>", "<?php echo $view['translator']->trans('dashboard.organicSearch'); ?>"],
                                            ];
                                            <?php foreach ($summaryChart as $item): ?>
                                            var data = new Date(<?php echo substr($item['ga:date'],0,4); ?>, <?php echo substr($item['ga:date'],4,2); ?>-1, <?php echo substr($item['ga:date'],6,2); ?>);
                                            var d = new Date();
                                            if(data.getDate()+data.getMonth() != d.getDate()+d.getMonth()){
                                                tableSessions.push([data, <?php echo $item['sessions']; ?>, <?php echo $item['organicSearches']; ?>]);
                                            }
                                            <?php endforeach; ?>
                                        </script>
                                        <div id="sessions-wykres">
                                            <div class="pleasWait  big">
                                                <p><?php echo $view['translator']->trans('configuration.ga.report.waiting', [], 'analytics'); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row subTytul">
                                <div class="columns large-12 text-left">
                                    <h2 style="margin-top:0px;">
                                        <i class="icon-chart-pie"></i>
                                        <span><?php echo $view['translator']->trans('dashboard.gaSourceTitle'); ?></span>
                                    </h2>
                                </div>
                            </div>
                            <div class="row">
                                <div class="columns large-6 medium-6 small-12">
                                    <div class="panel white channelGrouping-wykres">
                                        <div class="panelHeader">
                                            <h3><?php echo $view['translator']->trans('configuration.ga.report.sourcing', [], 'analytics'); ?></h3>
                                            <h4><?php echo $view['translator']->trans('configuration.ga.report.sourcingDesc', [], 'analytics'); ?></h4>
                                        </div>
                                        <div id="channelGrouping-wykres">
                                            <script>
                                                var tableChannel = [];
                                                <?php foreach ($channels as $channel): ?>
                                                    tableChannel.push(['<?php echo $channel['ga:channelGrouping']; ?>', <?php echo $channel['sessions']; ?>]);
                                                <?php endforeach; ?>
                                            </script>
                                            <div class="pleasWait  big">
                                                <p><?php echo $view['translator']->trans('configuration.ga.report.waiting', [], 'analytics'); ?></p>
                                            </div>
                                        </div>
                                        <div class="legenda">
                                            <strong><?php echo $view['translator']->trans('configuration.ga.report.explanation', [], 'analytics'); ?>: </strong>  <br>
                                            <ul style="list-style: none;">
                                                <li>
                                                    <span class="kolko blueBackgorunRound"></span> <em><u>Direct</u></em> - <?php echo $view['translator']->trans('configuration.ga.report.explanationFirst', [], 'analytics'); ?>
                                                </li>
                                                <li>
                                                    <span class="kolko redBackgroundRound"></span> <em><u>Organic Search</u></em> - <?php echo $view['translator']->trans('configuration.ga.report.explanationSecond', [], 'analytics'); ?>
                                                </li>
                                                <li>
                                                    <span class="kolko orangeBackgroundRound"></span> <em><u>Referral</u></em> - <?php echo $view['translator']->trans('configuration.ga.report.explanationThird', [], 'analytics'); ?>
                                                </li>
                                                <li>
                                                    <span class="kolko greenBackgroundRound"></span> <em><u>Social</u></em> - <?php echo $view['translator']->trans('configuration.ga.report.explanationFourst', [], 'analytics'); ?>
                                                </li>
                                        </div>
                                    </div>
                                </div>
                                <div class="columns large-6 medium-6 small-12">
                                    <div class="panel white sessionsSEO-liczba ikonaLiczba" title="<?php echo $view['translator']->trans('configuration.ga.report.websiteVisits', [], 'analytics'); ?>">
                                        <div class="row">
                                            <div class="columns large-2 medium-3 small-3 ikona">
                                                <i class="icon-chart-bar"></i>
                                            </div>
                                            <div class="columns large-10 medium-9 small-9 liczba end">
                                                <h3><?php echo $view['translator']->trans('configuration.ga.report.websiteVisitsTitle', [], 'analytics'); ?>:</h3>
                                                <div id="sessionsSEO-liczba">
                                                    <div class="row">
                                                        <?php foreach ($channels as $channel): ?>
                                                            <?php if($channel['ga:channelGrouping'] == 'Organic Search'): ?>
                                                                <div class="columns small-6 medium-3">
                                                                    <h2><?php echo number_format($channel['sessions'], 0, ',', ' '); ?></h2>
                                                                    <small><?php echo $view['translator']->trans('dashboard.visit'); ?></small>
                                                                </div>
                                                                <div class="columns small-6 medium-3">
                                                                    <h2><?php echo number_format($channel['users'], 0, ',', ' '); ?></h2>
                                                                    <small><?php echo $view['translator']->trans('dashboard.users'); ?></small>
                                                                </div>
                                                                <div class="columns small-6 medium-3">
                                                                    <h2>
                                                                        <?php echo number_format($channel['pageviews'], 0, ',', ' '); ?>
                                                                    </h2>
                                                                    <small><?php echo $view['translator']->trans('dashboard.visitPages'); ?></small>
                                                                </div>
                                                                <div class="columns small-6 medium-3">
                                                                    <h2><?php echo number_format($channel['hits'], 0, ',', ' '); ?></h2>
                                                                    <small><?php echo $view['translator']->trans('dashboard.interaction'); ?></small>
                                                                </div>
                                                                <?php endif; ?>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="panel white channelGrouping-tabela">
                                        <div class="panelHeader">
                                            <h3><?php echo $view['translator']->trans('configuration.ga.report.channel', [], 'analytics'); ?> </h3>
                                            <h4><?php echo $view['translator']->trans('configuration.ga.report.channelDesc', [], 'analytics'); ?>. </h4>
                                        </div>
                                        <div id="channelGrouping-tabela">
                                            <table>
                                                <header>
                                                    <tr>
                                                        <th><?php echo $view['translator']->trans('dashboard.channels'); ?></th>
                                                        <th><?php echo $view['translator']->trans('dashboard.sessions'); ?></th>
                                                        <th><?php echo $view['translator']->trans('dashboard.newSessions'); ?></th>
                                                        <th><?php echo $view['translator']->trans('dashboard.newUser'); ?></th>
                                                        <th><?php echo $view['translator']->trans('dashboard.bounceRate'); ?></th>
                                                        <th><?php echo $view['translator']->trans('dashboard.bounce'); ?></th>
                                                        <th><?php echo $view['translator']->trans('dashboard.events'); ?></th>
                                                        <th><?php echo $view['translator']->trans('dashboard.goals'); ?></th>
                                                    </tr>
                                                </header>
                                                <body>
                                                    <?php foreach ($channels as $channel): ?>
                                                    <tr>
                                                        <td><strong><?php echo $channel['ga:channelGrouping']; ?></strong></td>
                                                        <td><?php echo number_format($channel['sessions'], 0, ',', ' '); ?></td>
                                                        <td><?php echo number_format($channel['percentNewSessions'], 2, ',', ' '); ?>%</td>
                                                        <td><?php echo number_format($channel['newUsers'], 0, ',', ' '); ?></td>
                                                        <td><?php echo number_format($channel['bounceRate'], 2, ',', ' '); ?></td>
                                                        <td><?php echo number_format($channel['bounces'], 0, ',', ' '); ?></td>
                                                        <td><?php echo number_format($channel['events'], 0, ',', ' '); ?></td>
                                                        <td><?php echo number_format($channel['goalCompletionsAll'], 0, ',', ' '); ?></td>
                                                    </tr>
                                                    <?php endforeach; ?>
                                                </body>
                                            </table>
                                        </div>
                                        <div class="legenda">
                                            <strong><?php echo $view['translator']->trans('configuration.ga.report.explanation', [], 'analytics'); ?>: </strong>  <br>
                                            <ul>
                                                <li>
                                                    <?php echo $view['translator']->trans('configuration.ga.report.explanationSession', [], 'analytics'); ?>
                                                </li>
                                                <li>
                                                    <?php echo $view['translator']->trans('configuration.ga.report.explanationBounce', [], 'analytics'); ?>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/dashboard.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
