<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_news_index')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('search.meta.title', [], 'search')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/search.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><a href="<?php echo $view['router']->path('wi_admin_core_search_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.search', [], 'search'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-search-outline"></i><?php echo $view['translator']->trans('search.title', [], 'search'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleDesc') ?>
    <strong><?php echo $view['translator']->trans('search.desc', [], 'search'); ?>:</strong>
    <?php echo $search; ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>

<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-doc-text-1"></i>
            <span><?php echo $view['translator']->trans('searchBox.pageTitle', [], 'search'); ?>:</span>
        </h3>
    </div>
    <div class="box-body " style="display: block;">
        <?php if ($pages && $pages->count() == 0): ?>
            <?php echo $view['translator']->trans('searchBox.noResult', [], 'search'); ?>
        <?php endif; ?>
        <?php if($pages): ?>
            <?php foreach ($pages as $page): ?>
                <div class="row resultSearchRow">
                    <div class="columns">
                        <?php if ($view['security']->isGranted('ROLE_PAGES_INDEX')): ?>
                            <h5><a href="<?php echo $view['router']->path('wi_admin_pages_show', ['id' => $page->getId()]); ?>" class=""><?php echo $page->getTitle(); ?></a></h5>
                        <?php else: ?>
                            <h5><?php echo $page->getTitle(); ?></h5>
                        <?php endif; ?>
                        <a href="<?php echo $view['front']->getMetaCanonical($page); ?>" title="<?php echo $view['front']->getMetaTitle($page); ?>"><?php echo $view['front']->getMetaCanonical($page); ?></a>
                        <p><?php echo $view['front']->getMetaDescription($page); ?></p>
                        <div class="buttonItemsBox">
                            <div class="buttonsItems">
                                <?php if ($view['security']->isGranted('ROLE_PAGES_INDEX')): ?>
                                    <a href="<?php echo $view['router']->path('wi_admin_pages_show', ['id' => $page->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a> /
                                <?php endif; ?>
                                <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                                    <a href="<?php echo $view['router']->path('wi_admin_pages_edit', ['id' => $page->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a> /
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            <div class="row">
                <div class="columns text-center">
                    <?php echo $view['knp_pagination']->render($pages); ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-doc-text-1"></i>
            <span><?php echo $view['translator']->trans('searchBox.newsTitle', [], 'search'); ?>:</span>
        </h3>
    </div>
    <div class="box-body " style="display: block;">
        <?php if ($news && $news->count() == 0): ?>
            <?php echo $view['translator']->trans('searchBox.noResult', [], 'search'); ?>
        <?php endif; ?>
        <?php if($news): ?>
            <?php foreach ($news as $item): ?>
            <div class="row resultSearchRow">
                <div class="columns">
                    <?php if ($view['security']->isGranted('ROLE_NEWS_INDEX')): ?>
                        <h5><a href="<?php echo $view['router']->path('wi_admin_news_show', ['id' => $item->getId()]); ?>" class=""><?php echo $item->getTitle(); ?></a></h5>
                    <?php else: ?>
                        <h5><?php echo $item->getTitle(); ?></h5>
                    <?php endif; ?>
                    <a href="<?php echo $view['front']->getMetaCanonical($item); ?>" title="<?php echo $view['front']->getMetaTitle($item); ?>"><?php echo $view['front']->getMetaCanonical($item); ?></a>
                    <p><?php echo $view['front']->getMetaDescription($item); ?></p>
                    <div class="buttonItemsBox">
                        <div class="buttonsItems">
                            <?php if ($view['security']->isGranted('ROLE_NEWS_INDEX')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_news_show', ['id' => $item->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a> /
                            <?php endif; ?>
                            <?php if ($view['security']->isGranted('ROLE_NEWS_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_news_edit', ['id' => $item->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a> /
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        <div class="row">
            <div class="columns text-center">
                <?php echo $view['knp_pagination']->render($news); ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-doc-text-1"></i>
            <span><?php echo $view['translator']->trans('searchBox.blogTitle', [], 'search'); ?>:</span>
        </h3>
    </div>
    <div class="box-body " style="display: block;">
        <?php if ($blog && $blog->count() == 0): ?>
            <?php echo $view['translator']->trans('searchBox.noResult', [], 'search'); ?>
        <?php endif; ?>
        <?php if($blog): ?>
            <?php foreach ($blog as $item): ?>
                <div class="row resultSearchRow">
                    <div class="columns">
                        <?php if ($view['security']->isGranted('ROLE_NEWS_INDEX')): ?>
                            <h5><a href="<?php echo $view['router']->path('wi_admin_news_show', ['id' => $item->getId()]); ?>" class=""><?php echo $item->getTitle(); ?></a></h5>
                        <?php else: ?>
                            <h5><?php echo $item->getTitle(); ?></h5>
                        <?php endif; ?>
                        <a href="<?php echo $view['front']->getMetaCanonical($item); ?>" title="<?php echo $view['front']->getMetaTitle($item); ?>"><?php echo $view['front']->getMetaCanonical($item); ?></a>
                        <p><?php echo $view['front']->getMetaDescription($item); ?></p>
                        <div class="buttonItemsBox">
                            <div class="buttonsItems">
                                <?php if ($view['security']->isGranted('ROLE_NEWS_INDEX')): ?>
                                    <a href="<?php echo $view['router']->path('wi_admin_news_show', ['id' => $item->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a> /
                                <?php endif; ?>
                                <?php if ($view['security']->isGranted('ROLE_NEWS_EDIT')): ?>
                                    <a href="<?php echo $view['router']->path('wi_admin_news_edit', ['id' => $item->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a> /
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            <div class="row">
                <div class="columns text-center">
                    <?php echo $view['knp_pagination']->render($blog); ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/search.js') ?>"></script>
<?php $view['slots']->stop(); ?>
