<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_core_seo_index')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('seo.meta.title', [], 'seo')); ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/seo.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li>
    <?php echo $view['translator']->trans('main-menu.administration'); ?>
</li>
<li><a href="<?php echo $view['router']->path('wi_admin_core_seo_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.seo', [], 'seo'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-globe"></i><?php echo $view['translator']->trans('seo.title', [], 'seo'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
<div class="generate-type-labels">
    <div class="generate-type-label"><span class="generate-type type-1"><?php echo $view['translator']->trans('seo.labels.green.title', [], 'seo'); ?></span> — <?php echo $view['translator']->trans('seo.labels.green.desc', [], 'seo'); ?></div>
    <div class="generate-type-label"><span class="generate-type type-2"><?php echo $view['translator']->trans('seo.labels.blue.title', [], 'seo'); ?></span> — <?php echo $view['translator']->trans('seo.labels.blue.desc', [], 'seo'); ?></div>
    <div class="generate-type-label"><span class="generate-type type-3"><?php echo $view['translator']->trans('seo.labels.red.title', [], 'seo'); ?></span> — <?php echo $view['translator']->trans('seo.labels.red.desc', [], 'seo'); ?></div>
    <div class="generate-type-label"><span class="generate-type type-4"><?php echo $view['translator']->trans('seo.labels.grey.title', [], 'seo'); ?></span> — <?php echo $view['translator']->trans('seo.labels.grey.desc', [], 'seo'); ?></div>
</div>
<hr>

<h4><?php echo $view['translator']->trans('seo.section.pages.title', [], 'seo'); ?></h4>
<div class="seo-tabs">
    <ul class="tabs" data-deep-link="true" data-update-history="true" data-deep-link-smudge="true" data-deep-link-smudge="500" data-tabs id="deeplinked-tabs">
        <li class="tabs-title is-active"><a href="#pages-metadata" aria-selected="true"><i class="icon-chart-bar-2"></i> <?php echo $view['translator']->trans('seo.section.pages.tabs.metadata', [], 'seo'); ?></a></li>
        <li class="tabs-title"><a href="#pages-og" aria-selected="true"><i class="icon-chart-pie"></i> <?php echo $view['translator']->trans('seo.section.pages.tabs.og', [], 'seo'); ?></a></li>
    </ul>

    <div class="tabs-content" data-tabs-content="deeplinked-tabs">
        <div class="tabs-panel is-active" id="pages-metadata">
            <?php echo $view->render('WiAdminCoreBundle:Seo:Pages/metadata.html.php', [
                'pages' => $pages,
            ]); ?>
        </div>
        <div class="tabs-panel" id="pages-og">
            <?php echo $view->render('WiAdminCoreBundle:Seo:Pages/og.html.php', [
                'pages' => $pages,
            ]); ?>
        </div>
    </div>
</div>

<hr>
<h4><?php echo $view['translator']->trans('seo.section.news.title', [], 'seo'); ?></h4>
<div class="seo-tabs">
    <ul class="tabs" data-deep-link="true" data-update-history="true" data-deep-link-smudge="true" data-deep-link-smudge="500" data-tabs id="deeplinked-tabs">
        <li class="tabs-title is-active"><a href="#news-metadata" aria-selected="true"><i class="icon-chart-bar-2"></i> <?php echo $view['translator']->trans('seo.section.news.tabs.metadata', [], 'seo'); ?></a></li>
        <li class="tabs-title"><a href="#news-og" aria-selected="true"><i class="icon-chart-pie"></i> <?php echo $view['translator']->trans('seo.section.news.tabs.og', [], 'seo'); ?></a></li>
    </ul>

    <div class="tabs-content" data-tabs-content="deeplinked-tabs">
        <div class="tabs-panel is-active" id="news-metadata">
            <?php echo $view->render('WiAdminCoreBundle:Seo:News/metadata.html.php', [
                'news' => $news,
            ]); ?>
        </div>
        <div class="tabs-panel" id="news-og">
            <?php echo $view->render('WiAdminCoreBundle:Seo:News/og.html.php', [
                'news' => $news,
            ]); ?>
        </div>
    </div>
</div>

<hr>
<h4><?php echo $view['translator']->trans('seo.section.news_category.title', [], 'seo'); ?></h4>
<div class="seo-tabs">
    <ul class="tabs" data-deep-link="true" data-update-history="true" data-deep-link-smudge="true" data-deep-link-smudge="500" data-tabs id="deeplinked-tabs">
        <li class="tabs-title is-active"><a href="#news-category-metadata" aria-selected="true"><i class="icon-chart-bar-2"></i> <?php echo $view['translator']->trans('seo.section.news_category.tabs.metadata', [], 'seo'); ?></a></li>
        <li class="tabs-title"><a href="#news-category-og" aria-selected="true"><i class="icon-chart-pie"></i> <?php echo $view['translator']->trans('seo.section.news_category.tabs.og', [], 'seo'); ?></a></li>
    </ul>

    <div class="tabs-content" data-tabs-content="deeplinked-tabs">
        <div class="tabs-panel is-active" id="news-category-metadata">
            <?php echo $view->render('WiAdminCoreBundle:Seo:NewsCategories/metadata.html.php', [
                'newsCategories' => $newsCategories,
            ]); ?>
        </div>
        <div class="tabs-panel" id="news-category-og">
            <?php echo $view->render('WiAdminCoreBundle:Seo:NewsCategories/og.html.php', [
                'newsCategories' => $newsCategories,
            ]); ?>
        </div>
    </div>
</div>

<hr>
<h4><?php echo $view['translator']->trans('seo.section.forms.title', [], 'seo'); ?></h4>
<div class="seo-tabs">
    <ul class="tabs" data-deep-link="true" data-update-history="true" data-deep-link-smudge="true" data-deep-link-smudge="500" data-tabs id="deeplinked-tabs">
        <li class="tabs-title is-active"><a href="#forms-metadata" aria-selected="true"><i class="icon-chart-bar-2"></i> <?php echo $view['translator']->trans('seo.section.forms.tabs.metadata', [], 'seo'); ?></a></li>
        <li class="tabs-title"><a href="#forms-og" aria-selected="true"><i class="icon-chart-pie"></i> <?php echo $view['translator']->trans('seo.section.forms.tabs.og', [], 'seo'); ?></a></li>
    </ul>

    <div class="tabs-content" data-tabs-content="deeplinked-tabs">
        <div class="tabs-panel is-active" id="forms-metadata">
            <?php echo $view->render('WiAdminCoreBundle:Seo:Forms/metadata.html.php', [
                'forms' => $forms,
            ]); ?>
        </div>
        <div class="tabs-panel" id="forms-og">
            <?php echo $view->render('WiAdminCoreBundle:Seo:Forms/og.html.php', [
                'forms' => $forms,
            ]); ?>
        </div>
    </div>
</div>


<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<?php $view['slots']->stop(); ?>
