<?php

namespace Wi\Admin\CoreBundle\Service;

use Wi\Admin\ContactBundle\Entity\Form;
use Wi\Admin\CoreBundle\Service\Config;
use Wi\Admin\CoreBundle\Service\Seo\SeoDefault;
use Wi\Admin\CoreBundle\Service\Seo\SeoForm;
use Wi\Admin\CoreBundle\Service\Seo\SeoNews;
use Wi\Admin\CoreBundle\Service\Seo\SeoNewsCategory;
use Wi\Admin\CoreBundle\Service\Seo\SeoPage;
use Wi\Admin\NewsBundle\Entity\Category;
use Wi\Admin\NewsBundle\Entity\News;
use Wi\Admin\PageBundle\Entity\Page;

/**
 * Seo manager.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class Seo
{
    /**
     * @var Config
     */
    private $config;

    /**
     * @var SeoDefault
     */
    private $seoDefault;

    /**
     * @var SeoForm
     */
    private $seoForm;

    /**
     * @var SeoNews
     */
    private $seoNews;

    /**
     * @var SeoNewsCategory
     */
    private $seoNewsCategory;

    /**
     * @var SeoPage
     */
    private $seoPage;

    /**
     * Constructor.
     *
     * @param Config $config
     * @param SeoDefault $seoDefault
     * @param SeoNews $seoNews
     * @param SeoPage $seoPage
     */
    public function __construct(Config $config, SeoDefault $seoDefault, SeoForm $seoForm, SeoNews $seoNews, SeoNewsCategory $seoNewsCategory, SeoPage $seoPage)
    {
        $this->config = $config;
        $this->seoDefault = $seoDefault;
        $this->seoForm = $seoForm;
        $this->seoNews = $seoNews;
        $this->seoNewsCategory = $seoNewsCategory;
        $this->seoPage = $seoPage;
    }

    // -------------------------------------------------------------------------

    /**
     * Zwraca tablicę wygenerowanych metadanych dla przekazanego obiektu
     * wraz ze sposobem generowania poszczególnych danych.
     *
     * @param object $obj
     * @return array
     */
    public function getMetaArray($obj)
    {
        switch ($this->getClass($obj)) {
            case Page::class: return $this->seoPage->getMetaArray($obj);
            case News::class: return $this->seoNews->getMetaArray($obj);
            case Category::class: return $this->seoNewsCategory->getMetaArray($obj);
            case Form::class: return $this->seoForm->getMetaArray($obj);
            default: throw new \Exception('You haven\'t pass the correct object.');
        }
    }

    /**
     * Zwraca tablicę wygenerowanych metadanych dla obiektu. Jeśli obiekt
     * nie został przekazany to zwraca tablicę metadanych dla strony głównej.
     *
     * @param object $obj
     * @return array
     */
    public function getMetaArrayValues($obj = null)
    {
        switch ($this->getClass($obj)) {
            case Page::class: return $this->seoPage->getMetaArrayValues($obj);
            case News::class: return $this->seoNews->getMetaArrayValues($obj);
            case Category::class: return $this->seoNewsCategory->getMetaArrayValues($obj);
            case Form::class: return $this->seoForm->getMetaArrayValues($obj);
            default: return $this->seoDefault->getMetaArrayValues();
        }
    }

    /**
     * Zwraca tablicę wygenerowanych danych OpenGraph dla przekazanego obiektu
     * wraz ze sposobem generowania poszczególnych danych.
     *
     * @param object $obj
     * @return array
     */
    public function getOgArray($obj)
    {
        switch ($this->getClass($obj)) {
            case Page::class: return $this->seoPage->getOgArray($obj);
            case News::class: return $this->seoNews->getOgArray($obj);
            case Category::class: return $this->seoNewsCategory->getOgArray($obj);
            case Form::class: return $this->seoForm->getOgArray($obj);
            default: throw new \Exception('You haven\'t pass the correct object.');
        }
    }

    /**
     * Zwraca wygenerowane metadane dla przekazanego obiektu.
     *
     * @param object $obj
     * @return string
     */
    public function getMeta($obj = null)
    {
        switch ($this->getClass($obj)) {
            case Page::class: return $this->seoPage->getMeta($obj);
            case News::class: return $this->seoNews->getMeta($obj);
            case Category::class: return $this->seoNewsCategory->getMeta($obj);
            case Form::class: return $this->seoForm->getMeta($obj);
            default: return $this->seoDefault->getMeta();
        }
    }

    /**
     * Pobiera adres kanoniczny dla przekazanego obiektu.
     *
     * @param object $obj
     * @return string
     */
    public function getCanonical($obj = null) : string
    {
        switch ($this->getClass($obj)) {
            case Page::class: return $this->seoPage->getCanonicalGenerate($obj)['value'];
            case News::class: return $this->seoNews->getCanonicalGenerate($obj)['value'];
            case Category::class: return $this->seoNewsCategory->getCanonicalGenerate($obj)['value'];
            case Form::class: return $this->seoForm->getCanonicalGenerate($obj)['value'];
            default: return $this->seoDefault->getCanonicalGenerate()['value'];
        }
    }

    // -------------------------------------------------------------------------

    /**
     * Pobiera nazwę obiektu.
     *
     * @param object $obj
     * @return string|null
     */
    private function getClass($obj)
    {
        if (! is_null($obj)) {
            return \Doctrine\Common\Util\ClassUtils::getRealClass(get_class($obj));
        }

        return null;
    }
}
