<?php

namespace Wi\Admin\CoreBundle\Service;

use Symfony\Component\HttpFoundation\RequestStack;

class Utils
{
    /**
     * @var RequestStack
     */
    private $requestStack;

    /**
     * @var RequestContext
     */
    private $requestContext;

    /**
     * Constructor.
     *
     * @param RequestStack $requestStack
     * @param RequestContext $requestContext
     */
    public function __construct(RequestStack $requestStack)
    {
        $this->requestStack = $requestStack;
    }

    // -------------------------------------------------------------------------

    /**
     * Zwraca bezwględny adres do zasobu.
     *
     * @param string $path
     * @return string
     */
    public function absoluteUrL($path)
    {
        return $this->getBaseUrl() . $path;
    }

    /**
     * Pobiera bazowy adres URL.
     *
     * @return string
     */
    public function getBaseUrl()
    {
        $request = $this->requestStack->getMasterRequest();

        return $request->getScheme() . '://' . $request->getHttpHost() . $request->getBasePath() . '/';
    }
}
