<?php

namespace Wi\Admin\CoreBundle\Templating\Helper;

use Symfony\Component\Templating\Helper\Helper;
use Wi\Admin\CoreBundle\Service\Config;

/**
 * Config Helper.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ConfigHelper extends Helper
{
    /**
     * @var Config
     */
    private $config;

    /**
     * Constructor.
     *
     * @param Config $config
     */
    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    /**
     * Get config.
     *
     * @param string $key
     * @return string
     * @throws \Exception If a placeholder references a configuration that does not exist.
     */
    public function get($key)
    {
        return $this->config->get($key);
    }

    /**
     * Gets a parameter.
     *
     * @param string $name The parameter name
     * @return mixed The parameter value
     */
    public function getParameter($name)
    {
        return $this->config->getParameter($name);
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'config';
    }
}
